/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.Client;
import com.crankuptheamps.client.CommandId;
import com.crankuptheamps.client.CompositeMessageBuilder;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.exception.AMPSException;
import com.crankuptheamps.client.fields.CommandField;
import java.nio.charset.StandardCharsets;

public class Command {
    Message _message;
    private boolean _expiration_isSet;
    private byte[] _data;
    private byte[] _topic;
    private CommandId _commandId;
    private CommandId _queryId;
    private CommandId _subId;
    private int _dataLength;
    private int _dataOffset;
    private int _topicLength;
    private int _topicOffset;
    private int _ackType;
    private int _batchSize = 10;
    private int _command;
    private int _expiration;
    private int _topN = -1;
    private long _clientSequenceNumber;
    private long _timeout = 0L;
    private String _bookmark;
    private String _correlationId;
    private String _dataString;
    private String _filter;
    private String _options;
    private String _orderBy;
    private String _sowKey;
    private String _sowKeys;
    private String _topicString;

    private void init(int command) {
        this._command = command;
        this._bookmark = null;
        this._commandId = null;
        this._correlationId = null;
        this._data = null;
        this._dataString = null;
        this._filter = null;
        this._options = null;
        this._orderBy = null;
        this._queryId = null;
        this._sowKey = null;
        this._sowKeys = null;
        this._subId = null;
        this._topic = null;
        this._topicString = null;
        this._ackType = 0;
        this._batchSize = 10;
        this._clientSequenceNumber = 0L;
        this._expiration = 0;
        this._timeout = 0L;
        this._topN = -1;
        this._expiration_isSet = false;
        if ((this._command & 0x218F5) == 0 || this._command == 32) {
            this._commandId = CommandId.nextIdentifier();
            if (this.isSow()) {
                this._queryId = this._commandId;
            }
            if (this.isSubscribe()) {
                this._subId = this._commandId;
            }
        }
    }

    @Deprecated
    public String getSOWKey() {
        return this._sowKey;
    }

    public String getSowKey() {
        return this._sowKey;
    }

    @Deprecated
    public Command setSOWKey(String sowKey) {
        this._sowKey = sowKey;
        return this;
    }

    public Command setSowKey(String sowKey) {
        this._sowKey = sowKey;
        return this;
    }

    public String getSowKeys() {
        return this._sowKeys;
    }

    @Deprecated
    public String getSOWKeys() {
        return this._sowKeys;
    }

    public Command setSowKeys(String sowKeys) {
        this._sowKeys = sowKeys;
        return this;
    }

    @Deprecated
    public Command setSOWKeys(String sowKeys) {
        this._sowKeys = sowKeys;
        return this;
    }

    public final boolean isSubscribe() {
        return this._command == 512 || this._command == 1024 || this._command == 256 || this._command == 2;
    }

    public final boolean isSow() {
        return this._command == 8 || this._command == 1024 || this._command == 256;
    }

    public boolean needsSequenceNumber() {
        return this._command == 1 || this._command == 64 || this._command == 32;
    }

    private int translateCommand(String command_) {
        CommandField cf = new CommandField();
        cf.set(command_.getBytes(StandardCharsets.ISO_8859_1));
        if (!CommandField.encodeCommand(cf.getValue()).equals(command_)) {
            throw new IllegalArgumentException("unknown command type " + command_);
        }
        return cf.getValue();
    }

    public Command() {
    }

    public Command(int command) {
        this.init(command);
    }

    public Command(String command) {
        this.init(this.translateCommand(command));
    }

    public Command reset(int command) {
        this.init(command);
        return this;
    }

    public Command reset(String command) {
        this.init(this.translateCommand(command));
        return this;
    }

    public CommandId getCommandId() {
        return this._commandId;
    }

    public Command setCommandId(CommandId commandId) {
        this._commandId = commandId;
        return this;
    }

    public CommandId getQueryId() {
        return this._queryId;
    }

    public Command setQueryId(CommandId queryId) {
        this._queryId = queryId;
        return this;
    }

    public int getCommand() {
        return this._command;
    }

    public Command setCommand(int command) {
        this._command = command;
        return this;
    }

    public String getTopic() {
        if (this._topic == null) {
            return this._topicString;
        }
        if (this._message == null) {
            return new String(this._topic, this._topicOffset, this._topicLength, StandardCharsets.ISO_8859_1);
        }
        return new String(this._topic, this._topicOffset, this._topicLength, this._message.getDecoder().charset());
    }

    public Command setTopic(String topic) {
        this._topicString = topic;
        this._topic = null;
        return this;
    }

    public Command setTopic(byte[] topic, int offset, int length) {
        this._topic = topic;
        this._topicString = null;
        this._topicLength = length;
        this._topicOffset = 0;
        return this;
    }

    public String getFilter() {
        return this._filter;
    }

    public Command setFilter(String filter) {
        this._filter = filter;
        return this;
    }

    public String getOrderBy() {
        return this._orderBy;
    }

    public Command setOrderBy(String orderBy) {
        this._orderBy = orderBy;
        return this;
    }

    public CommandId getSubId() {
        return this._subId;
    }

    public Command setSubId(CommandId subId) {
        if (subId != null) {
            this._subId = subId;
        }
        return this;
    }

    public Command setSubId(String subId) {
        if (subId != null) {
            this._subId = new CommandId(subId);
        }
        return this;
    }

    public String getBookmark() {
        return this._bookmark;
    }

    public Command setBookmark(String bookmark) {
        this._bookmark = bookmark;
        return this;
    }

    public String getOptions() {
        return this._options;
    }

    public Command setOptions(String options) {
        this._options = options;
        return this;
    }

    public int getAckType() {
        return this._ackType;
    }

    public Command setAckType(int ackType) {
        if (ackType == 0 || ackType == 8) {
            if (this._commandId != null && (this._command & 0x218F5) != 0) {
                this._commandId = null;
            }
        } else if (this._commandId == null) {
            this._commandId = CommandId.nextIdentifier();
        }
        this._ackType = ackType;
        return this;
    }

    public Command addAckType(int ackType) {
        this._ackType |= ackType;
        return this;
    }

    public String getData() {
        if (this._data == null) {
            return this._dataString;
        }
        if (this._message == null) {
            return new String(this._data, this._dataOffset, this._dataLength, StandardCharsets.ISO_8859_1);
        }
        return new String(this._data, this._dataOffset, this._dataLength, this._message.getDecoder().charset());
    }

    public Command setData(String data) {
        this._dataString = data;
        this._data = null;
        return this;
    }

    public Command setData(byte[] data, int offset, int length) {
        this._dataString = null;
        this._data = data;
        this._dataOffset = offset;
        this._dataLength = length;
        return this;
    }

    public Command setData(CompositeMessageBuilder builder) {
        this._dataString = null;
        this._data = builder._bytes;
        this._dataOffset = 0;
        this._dataLength = builder._position;
        return this;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public Command setTimeout(long timeout) {
        this._timeout = timeout;
        return this;
    }

    public int getTopN() {
        return this._topN;
    }

    public Command setTopN(int topN) {
        this._topN = topN;
        return this;
    }

    public int getBatchSize() {
        return this._batchSize;
    }

    public Command setBatchSize(int batchSize) {
        this._batchSize = batchSize;
        return this;
    }

    public int getExpiration() {
        if (!this._expiration_isSet) {
            return 0;
        }
        return this._expiration;
    }

    public boolean hasExpiration() {
        return this._expiration_isSet;
    }

    public Command setExpiration(int expiration) {
        this._expiration = expiration;
        this._expiration_isSet = true;
        return this;
    }

    public void unsetExpiration() {
        this._expiration_isSet = false;
    }

    protected CommandId prepare(Client client_) throws AMPSException {
        if (this._message == null) {
            this._message = client_.allocateMessage();
        } else {
            this._message.reset();
        }
        this._message.setCommand(this._command);
        if (this._commandId != null) {
            this._message.setCommandId(this._commandId);
        }
        this._message.setAckType(this._ackType);
        if (this._bookmark != null) {
            this._message.setBookmark(this._bookmark);
        }
        if (this._data != null) {
            this._message.setData(this._data, this._dataOffset, this._dataLength);
        } else if (this._dataString != null) {
            this._message.setData(this._dataString);
        }
        if (this._filter != null) {
            this._message.setFilter(this._filter);
        }
        if (this._options != null) {
            this._message.setOptions(this._options);
        }
        if (this._orderBy != null) {
            this._message.setOrderBy(this._orderBy);
        }
        if (this._queryId != null) {
            this._message.setQueryId(this._queryId);
        }
        if (this._subId != null) {
            this._message.setSubId(this._subId);
        }
        if (this._topic != null) {
            this._message.setTopic(this._topic, this._topicOffset, this._topicLength);
        } else if (this._topicString != null) {
            this._message.setTopic(this._topicString);
        }
        if (this._expiration_isSet) {
            this._message.setExpiration(this._expiration);
        }
        if (this._sowKey != null) {
            this._message.setSowKey(this._sowKey);
        }
        if (this._sowKeys != null) {
            this._message.setSowKeys(this._sowKeys);
        }
        if (this._batchSize > 1 && (this._command == 8 || this._command == 256 || this._command == 1024)) {
            this._message.setBatchSize(this._batchSize);
        }
        if (this._topN != -1) {
            this._message.setTopN(this._topN);
        }
        if (this._correlationId != null) {
            this._message.setCorrelationId(this._correlationId);
        }
        if (this._clientSequenceNumber > 0L && this.needsSequenceNumber()) {
            this._message.setSequence(this._clientSequenceNumber);
        }
        return this._commandId;
    }

    public Command setClientSequenceNumber(long seqNumber) {
        this._clientSequenceNumber = seqNumber;
        return this;
    }

    public long getClientSequenceNumber() {
        return this._clientSequenceNumber;
    }

    public Command setCorrelationId(String correlationId_) {
        this._correlationId = correlationId_;
        return this;
    }

    public String getCorrelationId() {
        return this._correlationId;
    }
}

