/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.Authenticator;
import com.crankuptheamps.client.ConnectionInfo;
import com.crankuptheamps.client.ServerChooser;
import com.crankuptheamps.client.exception.DisconnectedException;
import java.util.Collection;
import java.util.Iterator;

public class DefaultServerChooser
implements ServerChooser {
    String[] _uris = new String[5];
    private static final int DEFAULT_SIZE = 5;
    int _currentFree = 0;
    int _current = 0;

    public DefaultServerChooser add(String uri) {
        if (this._currentFree >= this._uris.length) {
            String[] newUris = new String[this._uris.length * 2];
            System.arraycopy(this._uris, 0, newUris, 0, this._uris.length);
            this._uris = newUris;
        }
        this._uris[this._currentFree] = uri;
        ++this._currentFree;
        return this;
    }

    public <T extends Collection<String>> DefaultServerChooser addAll(T uris) {
        int urisSize = uris.size();
        if (this._currentFree >= this._uris.length - urisSize) {
            int newLength = this._uris.length < urisSize ? this._uris.length + urisSize : this._uris.length * 2;
            String[] newUris = new String[newLength];
            System.arraycopy(this._uris, 0, newUris, 0, this._uris.length);
            this._uris = newUris;
        }
        Iterator<String> iterator = uris.iterator();
        while (iterator.hasNext()) {
            String uri;
            this._uris[this._currentFree] = uri = iterator.next();
            ++this._currentFree;
        }
        return this;
    }

    @Override
    public String getCurrentURI() {
        if (this._currentFree == 0) {
            return null;
        }
        if (this._current >= this._currentFree) {
            this._current = 0;
        }
        return this._uris[this._current];
    }

    @Override
    public Authenticator getCurrentAuthenticator() {
        return null;
    }

    @Override
    public void reportFailure(Exception exception, ConnectionInfo info) throws Exception {
        if (!(exception instanceof DisconnectedException)) {
            this.next();
        }
    }

    @Override
    public void reportSuccess(ConnectionInfo info) {
    }

    public void next() {
        this._current = (this._current + 1) % this._currentFree;
    }

    @Override
    public String getError() {
        return "";
    }
}

