/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.MemoryPublishStore;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.PublishStore;
import com.crankuptheamps.client.PublishStoreResizeHandler;
import com.crankuptheamps.client.Store;
import com.crankuptheamps.client.exception.DisconnectedException;
import com.crankuptheamps.client.exception.StoreException;
import com.crankuptheamps.client.exception.TimedOutException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class HybridPublishStore
implements Store {
    protected PublishStore _fileStore;
    protected MemoryPublishStore _memoryStore;
    protected int _cap;
    protected String _path;
    protected int _lowWatermark = 0;
    private boolean _holdSwapping = false;
    private final Lock _lock = new ReentrantLock();
    private final Condition _swapping = this._lock.newCondition();

    public HybridPublishStore(String path, int cap) throws StoreException {
        this._fileStore = new PublishStore(path);
        this._memoryStore = new MemoryPublishStore(cap + 1);
        if (this._fileStore.getLastPersisted() % 1000000L == 0L) {
            this._fileStore.discardUpTo(this._memoryStore.getLastPersisted());
        }
        this._cap = cap;
        this._lowWatermark = (int)((double)this._cap * 0.5);
        this._path = path;
    }

    public void setLowWatermark(int lowWatermark_) {
        this._lock.lock();
        try {
            if (lowWatermark_ < this._cap) {
                this._lowWatermark = lowWatermark_;
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public long getLowestUnpersisted() {
        long count = this._fileStore.getLowestUnpersisted();
        if (count == -1L) {
            return this._memoryStore.getLowestUnpersisted();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discardUpTo(long index) throws StoreException {
        this._lock.lock();
        try {
            while (this._holdSwapping) {
                try {
                    this._swapping.await(10L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {}
            }
            this._holdSwapping = true;
        }
        finally {
            this._lock.unlock();
        }
        try {
            if (index >= this._memoryStore.getLowestUnpersisted()) {
                this._memoryStore.discardUpTo(index);
            }
            this._fileStore.discardUpTo(index);
        }
        finally {
            this._signalLock();
        }
    }

    private void _signalLock() {
        this._lock.lock();
        try {
            this._holdSwapping = false;
            this._swapping.signalAll();
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replay(Store.StoreReplayer replayer) throws StoreException, DisconnectedException {
        this._lock.lock();
        try {
            while (this._holdSwapping) {
                try {
                    this._swapping.await(10L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {}
            }
            this._holdSwapping = true;
        }
        finally {
            this._lock.unlock();
        }
        try {
            this._fileStore.replay(replayer);
            this._memoryStore.replay(replayer);
        }
        finally {
            this._signalLock();
        }
    }

    @Override
    public boolean replaySingle(Store.StoreReplayer replayer, long index) throws StoreException, DisconnectedException {
        if (index < this._memoryStore.getLowestUnpersisted()) {
            return this._fileStore.replaySingle(replayer, index);
        }
        return this._memoryStore.replaySingle(replayer, index);
    }

    @Override
    public long unpersistedCount() {
        return this._fileStore.unpersistedCount() + this._memoryStore.unpersistedCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(Message message) throws StoreException {
        SwappingOutReplayer replayer = null;
        this._lock.lock();
        try {
            while (this._holdSwapping) {
                try {
                    this._swapping.await(10L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {}
            }
            long memUnpersistedCount = this._memoryStore.unpersistedCount();
            if (memUnpersistedCount >= (long)this._cap) {
                this._holdSwapping = true;
                replayer = new SwappingOutReplayer(this, (int)memUnpersistedCount - this._lowWatermark);
            }
        }
        finally {
            this._lock.unlock();
        }
        try {
            if (replayer != null) {
                this._memoryStore.replay(replayer);
                if (replayer.getErrors() == 0) {
                    this._memoryStore.discardUpTo(replayer.lastIndex());
                }
            }
            this._memoryStore.store(message);
        }
        catch (DisconnectedException e) {
            assert (false);
        }
        finally {
            this._lock.lock();
            if (replayer != null) {
                this._holdSwapping = false;
            }
            this._lock.unlock();
        }
    }

    @Override
    public void setMessage(Message m) {
        this._memoryStore.setMessage(m);
        this._fileStore.setMessage(m.copy());
    }

    @Override
    public long getLastPersisted() throws StoreException {
        return this._fileStore.getLastPersisted();
    }

    @Override
    public void flush() throws TimedOutException {
        this._memoryStore.flush();
        this._fileStore.flush();
    }

    @Override
    public void flush(long timeout) throws TimedOutException {
        long start = System.currentTimeMillis();
        this._memoryStore.flush(timeout);
        long remaining = timeout - (System.currentTimeMillis() - start);
        if (remaining <= 0L) {
            throw new TimedOutException("Timed out waiting to flush publish store.");
        }
        this._fileStore.flush(remaining);
    }

    @Override
    public void setResizeHandler(PublishStoreResizeHandler handler) {
        this._fileStore.setResizeHandler(handler);
        this._memoryStore.setResizeHandler(handler);
    }

    @Override
    public void close() throws Exception {
        this._memoryStore.close();
        this._fileStore.close();
    }

    private static class SwappingOutReplayer
    implements Store.StoreReplayer {
        HybridPublishStore _store;
        int _entries;
        int _errorCount;
        long _lastIndex;

        private SwappingOutReplayer(HybridPublishStore store_, int entries_) {
            this._store = store_;
            this._entries = entries_;
        }

        public int getErrors() {
            return this._errorCount;
        }

        public long lastIndex() {
            return this._lastIndex;
        }

        @Override
        public void execute(Message message) {
            if (this._entries > 0 && this._errorCount == 0) {
                try {
                    this._store._fileStore.store(message, false);
                    this._lastIndex = message.getSequence();
                }
                catch (StoreException e) {
                    ++this._errorCount;
                }
                --this._entries;
            }
        }
    }
}

