/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.JSONMessage;
import com.crankuptheamps.client.JSONProtocol;
import com.crankuptheamps.client.MessageHandler;
import com.crankuptheamps.client.ProtocolParser;
import com.crankuptheamps.client.exception.StreamException;
import java.nio.ByteBuffer;

public class JSONProtocolParser
implements ProtocolParser {
    private static final String LATIN1 = "ISO-8859-1";
    static final byte OPEN_BRACE = 123;
    static final byte CLOSE_BRACE = 125;
    static final byte QUOTE = 34;
    static final byte COLON = 58;
    static final byte BACKSLASH = 92;
    private final JSONMessage message;
    private ByteBuffer buffer = null;
    private int remainingBytes = 0;
    private StreamState state;
    private boolean in_quote = false;

    public JSONProtocolParser(JSONProtocol messageType) {
        this.message = messageType.allocateMessage();
    }

    @Override
    public void process(ByteBuffer buffer, int remainingBytes, MessageHandler listener) throws StreamException {
        this.buffer = buffer;
        this.remainingBytes = remainingBytes;
        this.state = StreamState.start;
        this.message.reset();
        this.message.setBuffer(buffer.array());
        while (this.read(this.message)) {
            listener.invoke(this.message);
        }
    }

    HeaderField extractHeaderField() throws StreamException {
        this.assertByte((byte)34);
        if (this.remainingBytes < 4) {
            throw new StreamException("stream corruption: premature end of header");
        }
        this.getByte();
        int name_start = this.buffer.position();
        this.scan_or_throw();
        this.assertByte((byte)34);
        int name_length = this.buffer.position() - name_start;
        if (this.remainingBytes < 2) {
            throw new StreamException("stream corruption: premature end of header");
        }
        this.getByte();
        this.assertByte((byte)58);
        this.getByte();
        byte[] pTag_ = this.buffer.array();
        switch (name_length) {
            case 1: {
                switch (pTag_[name_start + 0]) {
                    case 99: {
                        return HeaderField.Cmd;
                    }
                    case 116: {
                        return HeaderField.Tpc;
                    }
                    case 115: {
                        return HeaderField.Seq;
                    }
                    case 97: {
                        return HeaderField.AckTyp;
                    }
                    case 101: {
                        return HeaderField.Expn;
                    }
                    case 111: {
                        return HeaderField.Options;
                    }
                    case 108: {
                        return HeaderField.MsgLn;
                    }
                    case 107: {
                        return HeaderField.SowKey;
                    }
                    case 118: {
                        return HeaderField.Version;
                    }
                    case 120: {
                        return HeaderField.CrlId;
                    }
                }
                break;
            }
            case 2: {
                switch (pTag_[name_start + 1]) {
                    case 119: {
                        return HeaderField.Password;
                    }
                    case 115: {
                        return pTag_[name_start + 0] == 98 ? HeaderField.BtchSz : HeaderField.Timestamp;
                    }
                    case 109: {
                        return HeaderField.BkMrk;
                    }
                    case 112: {
                        return HeaderField.LeasePeriod;
                    }
                }
                break;
            }
            case 3: {
                switch (pTag_[name_start + 1]) {
                    case 109: {
                        return HeaderField.Cmd;
                    }
                    case 105: {
                        return HeaderField.CmdId;
                    }
                    case 99: {
                        return HeaderField.AckTyp;
                    }
                    case 101: {
                        return HeaderField.Seq;
                    }
                }
                break;
            }
            case 4: {
                switch (pTag_[name_start + 0]) {
                    case 111: {
                        return HeaderField.Options;
                    }
                    case 115: {
                        return HeaderField.SubIds;
                    }
                    case 103: {
                        return HeaderField.GrpSqNum;
                    }
                }
                break;
            }
            case 5: {
                switch (pTag_[name_start + 3]) {
                    case 105: {
                        return HeaderField.Tpc;
                    }
                    case 95: {
                        return HeaderField.TopN;
                    }
                }
                break;
            }
            case 6: {
                switch (pTag_[name_start + 1]) {
                    case 109: {
                        return HeaderField.CmdId;
                    }
                    case 105: {
                        return HeaderField.Fltr;
                    }
                    case 116: {
                        return HeaderField.Status;
                    }
                    case 101: {
                        return HeaderField.Reason;
                    }
                    case 117: {
                        return HeaderField.SubId;
                    }
                }
                break;
            }
            case 7: {
                switch (pTag_[name_start + 0]) {
                    case 109: {
                        return HeaderField.Matches;
                    }
                    case 117: {
                        return HeaderField.UsrId;
                    }
                    case 115: {
                        return HeaderField.SubIds;
                    }
                    case 118: {
                        return HeaderField.Version;
                    }
                }
                break;
            }
            case 8: {
                switch (pTag_[name_start + 6]) {
                    case 112: {
                        return HeaderField.AckTyp;
                    }
                    case 101: {
                        return HeaderField.Password;
                    }
                    case 114: {
                        return HeaderField.BkMrk;
                    }
                    case 105: {
                        return HeaderField.QId;
                    }
                    case 121: {
                        return HeaderField.SowKeys;
                    }
                }
                break;
            }
            case 9: {
                switch (pTag_[name_start + 0]) {
                    case 104: {
                        return HeaderField.Hrtbt;
                    }
                }
                break;
            }
            case 10: {
                switch (pTag_[name_start + 0]) {
                    case 101: {
                        return HeaderField.Expn;
                    }
                    case 98: {
                        return HeaderField.BtchSz;
                    }
                }
                break;
            }
            case 11: {
                switch (pTag_[name_start + 0]) {
                    case 99: {
                        return HeaderField.ClntName;
                    }
                }
                break;
            }
            case 13: {
                switch (pTag_[name_start + 0]) {
                    case 116: {
                        return HeaderField.TopicMatches;
                    }
                    case 103: {
                        return HeaderField.GrpSqNum;
                    }
                }
                break;
            }
            case 15: {
                switch (pTag_[name_start + 8]) {
                    case 100: {
                        return HeaderField.RecordsDeleted;
                    }
                    case 117: {
                        return HeaderField.RecordsUpdated;
                    }
                }
                break;
            }
            case 16: {
                switch (pTag_[name_start + 8]) {
                    case 105: {
                        return HeaderField.RecordsInserted;
                    }
                    case 114: {
                        return HeaderField.RecordsReturned;
                    }
                }
            }
        }
        return HeaderField.UNKNOWN;
    }

    int findValueEnd(boolean fieldNeedsUnescape) throws StreamException {
        int end_index;
        switch (this.peekByte()) {
            case 34: {
                this.getByte();
                if (fieldNeedsUnescape) {
                    end_index = this.unescapeField();
                } else {
                    this.scan_or_throw();
                    end_index = this.buffer.position();
                }
                this.assertByte((byte)34);
                if (this.remainingBytes <= 0) {
                    throw new StreamException("stream corruption: premature end of header");
                }
                this.getByte();
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                while (this.remainingBytes > 0 && this.peekByte() >= 48 && this.peekByte() <= 57) {
                    this.getByte();
                }
                end_index = this.buffer.position();
                break;
            }
            case 116: {
                if (this.remainingBytes < 4) {
                    throw new StreamException("stream corruption: premature end of header");
                }
                this.getByte();
                this.assertByte((byte)114);
                this.getByte();
                this.assertByte((byte)117);
                this.getByte();
                this.assertByte((byte)101);
                this.getByte();
                end_index = this.buffer.position();
                break;
            }
            case 102: {
                if (this.remainingBytes < 5) {
                    throw new StreamException("stream corruption: premature end of header");
                }
                this.getByte();
                this.assertByte((byte)97);
                this.getByte();
                this.assertByte((byte)108);
                this.getByte();
                this.assertByte((byte)115);
                this.getByte();
                this.assertByte((byte)101);
                this.getByte();
                end_index = this.buffer.position();
                break;
            }
            case 110: {
                if (this.remainingBytes < 4) {
                    throw new StreamException("stream corruption: premature end of header");
                }
                this.getByte();
                this.assertByte((byte)117);
                this.getByte();
                this.assertByte((byte)108);
                this.getByte();
                this.assertByte((byte)108);
                this.getByte();
                end_index = this.buffer.position();
                break;
            }
            default: {
                throw new StreamException("stream corruption: premature end of header");
            }
        }
        return end_index;
    }

    void extractFieldValue(JSONMessage message) throws StreamException {
        HeaderField field = this.extractHeaderField();
        boolean needsUnEscape = field == HeaderField.Tpc || field == HeaderField.UsrId || field == HeaderField.Password || field == HeaderField.ClntName || field == HeaderField.SubId || field == HeaderField.SubIds;
        int valueStart = this.peekByte() == 34 ? this.buffer.position() + 1 : this.buffer.position();
        int valueLength = this.findValueEnd(needsUnEscape) - valueStart;
        switch (field) {
            case AckTyp: {
                message._AckType.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case BtchSz: {
                message._BatchSize.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case BkMrk: {
                message._Bookmark.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case ClntName: {
                message._ClientName.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case Cmd: {
                message._Command.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case CmdId: {
                message._CommandId.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case CrlId: {
                message._CorrelationId.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case Expn: {
                message._Expiration.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case Fltr: {
                message._Filter.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case GrpSqNum: {
                message._GroupSeqNo.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case LeasePeriod: {
                message._LeasePeriod.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case Matches: {
                message._Matches.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case MsgLn: {
                message._Length.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case Options: {
                message._Options.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case Password: {
                message._Password.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case QId: {
                message._QueryId.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case Reason: {
                message._Reason.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case RecordsInserted: {
                message._RecordsInserted.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case RecordsUpdated: {
                message._RecordsUpdated.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case RecordsReturned: {
                message._RecordsReturned.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case RecordsDeleted: {
                message._RecordsDeleted.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case Seq: {
                message._Sequence.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case SubIds: {
                message._SubIds.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case SowKey: {
                message._SowKey.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case SowKeys: {
                message._SowKeys.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case Status: {
                message._Status.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case SubId: {
                message._SubId.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case Timestamp: {
                message._Timestamp.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case Tpc: {
                message._Topic.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case TopicMatches: {
                message._TopicMatches.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case TopN: {
                message._TopN.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case UsrId: {
                message._UserId.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
            case Version: {
                message._Version.set(this.buffer.array(), valueStart, valueLength);
                break;
            }
        }
        while (this.remainingBytes > 0 && this.peekByte() != 34 && this.peekByte() != 125) {
            this.getByte();
        }
    }

    private boolean read(JSONMessage m) throws StreamException {
        int messageLength;
        if (this.remainingBytes <= 0) {
            return false;
        }
        if (this.state != StreamState.in_sow) {
            m.setRawBufferOffset(this.buffer.position());
        }
        this.scan();
        if (this.remainingBytes <= 0) {
            return false;
        }
        this.assertByte((byte)123);
        this.getByte();
        while (this.remainingBytes > 0 && this.peekByte() != 125) {
            this.extractFieldValue(m);
        }
        this.assertByte((byte)125);
        this.getByte();
        int command = m.getCommand();
        if (this.state == StreamState.start && command == 8) {
            this.scan();
            if (this.remainingBytes <= 0) {
                return false;
            }
            this.assertByte((byte)123);
            this.getByte();
            while (this.remainingBytes > 0 && this.peekByte() != 125) {
                this.extractFieldValue(m);
            }
            this.assertByte((byte)125);
            this.getByte();
            this.state = StreamState.in_sow;
            messageLength = m._Length.getValue();
        } else {
            messageLength = this.state == StreamState.in_sow ? m._Length.getValue() : this.remainingBytes;
        }
        m._Data.set(this.buffer.array(), this.buffer.position(), messageLength);
        this.remainingBytes -= messageLength;
        this.buffer.position(this.buffer.position() + messageLength);
        m.setRawBufferLength(this.buffer.position() - m.getRawBufferOffset());
        return true;
    }

    private final void assertByte(byte b) throws StreamException {
        if (this.peekByte() != b) {
            throw new StreamException("stream corruption: expected '" + (char)b + "'");
        }
    }

    final byte getByte() {
        --this.remainingBytes;
        byte b = this.buffer.get();
        if (b == 34) {
            this.in_quote = !this.in_quote;
        }
        return b;
    }

    final byte peekByte() {
        return this.buffer.get(this.buffer.position());
    }

    private final char getUnescapedChar() {
        switch (this.peekByte()) {
            case 34: {
                return '\"';
            }
            case 92: {
                return '\\';
            }
            case 47: {
                return '/';
            }
            case 98: {
                return '\b';
            }
            case 102: {
                return '\f';
            }
            case 110: {
                return '\n';
            }
            case 114: {
                return '\r';
            }
            case 116: {
                return '\t';
            }
        }
        return '\u0000';
    }

    int unescapeField() {
        int b = this.buffer.position();
        while (this.remainingBytes > 0 && this.peekByte() != 34) {
            if (this.peekByte() == 92) {
                this.getByte();
                char unescapedChar = this.getUnescapedChar();
                --this.remainingBytes;
                this.buffer.get();
                this.buffer.put(b++, (byte)unescapedChar);
                continue;
            }
            this.buffer.put(b++, this.getByte());
        }
        return b;
    }

    boolean scan() {
        while (this.remainingBytes > 0 && (this.in_quote && this.peekByte() != 34 || !this.in_quote && this.peekByte() != 34 && this.peekByte() != 123 && this.peekByte() != 58 && this.peekByte() != 125)) {
            this.getByte();
        }
        return this.remainingBytes > 0;
    }

    void scan_or_throw() throws StreamException {
        if (!this.scan()) {
            throw new StreamException("stream corruption: premature end of header");
        }
    }

    private static enum StreamState {
        start,
        in_sow,
        end;

    }

    static enum HeaderField {
        AckTyp,
        BkMrk,
        BtchSz,
        ClntName,
        Cmd,
        CmdId,
        DlvMd,
        Drblty,
        Expn,
        Fltr,
        GrcPrd,
        GrpSqNum,
        Hrtbt,
        LeasePeriod,
        Matches,
        MsgLn,
        Options,
        Password,
        QId,
        Reason,
        RecordsInserted,
        RecordsUpdated,
        RecordsDeleted,
        RecordsReturned,
        Seq,
        SubIds,
        SowKey,
        SowKeys,
        Status,
        SubId,
        Timestamp,
        TmIntvl,
        Tpc,
        TopicMatches,
        TopN,
        UsrId,
        Version,
        CrlId,
        UNKNOWN;

    }
}

