/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.Protocol;
import com.crankuptheamps.client.exception.ProtocolException;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Properties;

public class ProtocolFactory {
    private static Hashtable<String, String> registry = new Hashtable();

    public static void register(String name, String msgType) throws ProtocolException {
        if (registry.containsKey(name)) {
            throw new ProtocolException("'" + name + "' is already registered.");
        }
        registry.put(name, msgType);
    }

    public static void unregister(String name) throws ProtocolException {
        if (!registry.containsKey(name)) {
            throw new ProtocolException("'" + name + "' is not a known Protocol, can not unregister.");
        }
        registry.remove(name);
    }

    public static Protocol createProtocol(String name, Properties props) throws ProtocolException {
        String mtName = "com.crankuptheamps.client." + name.toUpperCase() + "Protocol";
        if (registry.containsKey(name)) {
            mtName = registry.get(name);
        }
        try {
            Class<?> c = Class.forName(mtName);
            Constructor<?> ctor = c.getConstructor(Properties.class);
            return (Protocol)ctor.newInstance(props);
        }
        catch (Exception e) {
            throw new ProtocolException("'" + name + "' is not a valid Protocol.", e);
        }
    }

    static {
        registry.put("amps", "com.crankuptheamps.client.JSONProtocol");
    }
}

