/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.BlockPublishStore;
import com.crankuptheamps.client.MemoryStoreBuffer;
import com.crankuptheamps.client.exception.StoreException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class PublishStore
extends BlockPublishStore {
    static final int DEFAULT_INITIAL_BLOCKS = 10000;
    private int _initialCapacity;
    private boolean _truncateOnClose = false;

    public PublishStore(String path) throws StoreException {
        this(path, 10000);
    }

    public PublishStore(String path, int initialCapacity) throws StoreException {
        super(new MMapStoreBuffer(path), initialCapacity, true);
        this._initialCapacity = initialCapacity;
        this.recover();
        if (this._usedList == null) {
            this.growFreeListIfEmpty();
        }
    }

    public void truncateOnClose(boolean truncate) {
        this._truncateOnClose = truncate;
    }

    @Override
    public void close() throws Exception {
        if (this._buffer == null) {
            return;
        }
        long unpersistedCount = this.unpersistedCount();
        this._buffer.close();
        if (this._truncateOnClose && unpersistedCount == 0L && !System.getProperty("os.name").startsWith("Windows")) {
            FileChannel channel = new FileOutputStream(((MMapStoreBuffer)this._buffer)._path, true).getChannel();
            channel.truncate((long)this._initialCapacity * 2048L);
        }
        this._buffer = null;
    }

    public void sync() throws IOException {
        ((MMapStoreBuffer)this._buffer).sync();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    static class MMapStoreBuffer
    extends MemoryStoreBuffer {
        String _path;
        RandomAccessFile _file;
        FileChannel _channel;

        public MMapStoreBuffer(String path) throws StoreException {
            this._path = path;
            try {
                this._file = new RandomAccessFile(path, "rw");
            }
            catch (IOException e) {
                throw new StoreException(e);
            }
            this._channel = this._file.getChannel();
        }

        @Override
        public long getSize() throws IOException {
            if (this._buffer == null) {
                if (this._file.length() == 0L) {
                    return 0L;
                }
                this._buffer = this._channel.map(FileChannel.MapMode.READ_WRITE, 0L, this._file.length());
            }
            return this._buffer.capacity();
        }

        @Override
        public void setSize(long newSize) throws IOException {
            if (this._channel == null) {
                throw new IOException("The store is closed.");
            }
            if (this._buffer != null) {
                ((MappedByteBuffer)this._buffer).force();
            }
            this._buffer = this._channel.map(FileChannel.MapMode.READ_WRITE, 0L, newSize);
        }

        @Override
        public void close() throws Exception {
            this._buffer = null;
            this._store = null;
            if (this._channel != null) {
                this._channel.close();
            }
            if (this._file != null) {
                this._file.close();
            }
            this._channel = null;
            this._file = null;
        }

        public void sync() throws IOException {
            MappedByteBuffer b = (MappedByteBuffer)this._buffer;
            b.force();
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }
}

