/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.AMPSRunnable;
import com.crankuptheamps.client.DefaultDisconnectHandler;
import com.crankuptheamps.client.DefaultMessageHandler;
import com.crankuptheamps.client.MessageHandler;
import com.crankuptheamps.client.Protocol;
import com.crankuptheamps.client.ProtocolParser;
import com.crankuptheamps.client.TCPTransport;
import com.crankuptheamps.client.ThreadCreatedHandler;
import com.crankuptheamps.client.TransportDisconnectHandler;
import com.crankuptheamps.client.TransportFilter;
import com.crankuptheamps.client.URIProperties;
import com.crankuptheamps.client.exception.AlreadyConnectedException;
import com.crankuptheamps.client.exception.ConnectionRefusedException;
import com.crankuptheamps.client.exception.DisconnectedException;
import com.crankuptheamps.client.exception.InvalidURIException;
import com.crankuptheamps.client.exception.RetryOperationException;
import java.beans.ExceptionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.SocketFactory;

public class TCPTransportImpl {
    private URI _addr = null;
    protected Socket _socket = null;
    protected InputStream _inputStream = null;
    protected OutputStream _outputStream = null;
    public final Lock _lock = new ReentrantLock();
    volatile int _connectionVersion = 0;
    private volatile boolean _disconnecting = false;
    private Protocol _messageType = null;
    private MessageHandler _onMessage = DefaultMessageHandler.instance;
    private TransportDisconnectHandler _onDisconnect = DefaultDisconnectHandler.instance;
    private TCPReaderThread _readerThread = null;
    private ExceptionListener _exceptionListener = null;
    private Properties _properties = null;
    protected TransportFilter _filter = null;
    protected AMPSRunnable _idleRunnable = null;
    private int _readTimeout = 0;
    private int _connectTimeout = 0;
    private ThreadCreatedHandler _threadCreatedHandler = null;

    public TCPTransportImpl(Protocol messageType, Properties properties, TransportFilter filter) {
        this._messageType = messageType;
        this._properties = properties;
        this._filter = filter;
        this._readTimeout = TCPTransport.getDefaultReadTimeout();
        this._connectTimeout = TCPTransport.getDefaultConnectTimeout();
    }

    public void setMessageHandler(MessageHandler h) {
        this._onMessage = h;
    }

    public void setDisconnectHandler(TransportDisconnectHandler h) {
        this._onDisconnect = h;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this._exceptionListener = exceptionListener;
    }

    public void setThreadCreatedHandler(ThreadCreatedHandler h) {
        this._threadCreatedHandler = h;
    }

    public void setTransportFilter(TransportFilter filter) {
        this._filter = filter;
    }

    public void connect(URI addr) throws ConnectionRefusedException, AlreadyConnectedException, InvalidURIException {
        this._lock.lock();
        this._disconnecting = false;
        try {
            int i;
            Thread.interrupted();
            if (this._addr != null) {
                throw new AlreadyConnectedException("Already connected to AMPS at " + this._addr.getHost() + ":" + this._addr.getPort() + "\n");
            }
            this._socket = this.createSocket();
            URIProperties properties = new URIProperties(addr);
            if (this._properties != null) {
                properties.putAll((Map<?, ?>)this._properties);
            }
            this.applySocketProperties(properties);
            String default_ip_proto_prefer = System.getProperty("com.crankuptheamps.client.DEFAULT_IP_PROTOCOL_PREFER", "ipv4");
            if (!"ipv4".equals(default_ip_proto_prefer) && !"ipv6".equals(default_ip_proto_prefer)) {
                throw new IllegalArgumentException("Invalid value '" + default_ip_proto_prefer + "' for com.crankuptheamps.client.DEFAULT_IP_PROTOCOL_PREFER System Property");
            }
            String ip_proto_prefer = properties.getProperty("ip_protocol_prefer", default_ip_proto_prefer);
            if (!"ipv4".equals(ip_proto_prefer) && !"ipv6".equals(ip_proto_prefer)) {
                throw new InvalidURIException("Invalid value '" + ip_proto_prefer + "' for ip_protocol_prefer URI parameter");
            }
            int preferredAddrIndex = -1;
            InetAddress[] addrCandidates = InetAddress.getAllByName(addr.getHost());
            if ("ipv4".equals(ip_proto_prefer)) {
                for (i = 0; i < addrCandidates.length; ++i) {
                    if (!(addrCandidates[i] instanceof Inet4Address)) continue;
                    preferredAddrIndex = i;
                    break;
                }
                if (preferredAddrIndex == -1) {
                    for (i = 0; i < addrCandidates.length; ++i) {
                        if (!(addrCandidates[i] instanceof Inet6Address)) continue;
                        preferredAddrIndex = i;
                        break;
                    }
                }
                if (preferredAddrIndex == -1) {
                    throw new UnknownHostException();
                }
            } else {
                for (i = 0; i < addrCandidates.length; ++i) {
                    if (!(addrCandidates[i] instanceof Inet6Address)) continue;
                    preferredAddrIndex = i;
                    break;
                }
                if (preferredAddrIndex == -1) {
                    for (i = 0; i < addrCandidates.length; ++i) {
                        if (!(addrCandidates[i] instanceof Inet4Address)) continue;
                        preferredAddrIndex = i;
                        break;
                    }
                }
                if (preferredAddrIndex == -1) {
                    throw new UnknownHostException();
                }
            }
            this._socket.connect(new InetSocketAddress(addrCandidates[preferredAddrIndex], addr.getPort()));
            this.handshake();
            this._inputStream = this._socket.getInputStream();
            this._outputStream = this._socket.getOutputStream();
            int INTERNAL_TIMEOUT = 1000;
            this._socket.setSoTimeout(1000);
            ++this._connectionVersion;
            this._readerThread = new TCPReaderThread(this, this._messageType);
            this._readerThread.barrier.await();
            this._addr = addr;
        }
        catch (InvalidURIException iuex) {
            throw iuex;
        }
        catch (ClosedByInterruptException e) {
            Thread.interrupted();
            throw new ConnectionRefusedException("Interrupted, but please try again.", e);
        }
        catch (InterruptedException | BrokenBarrierException e) {
            Thread.interrupted();
            throw new ConnectionRefusedException("Sync with reader thread interrupted, but please try again.", e);
        }
        catch (IllegalArgumentException iaex) {
            throw new InvalidURIException("Error setting socket options", iaex);
        }
        catch (Exception ex) {
            throw new ConnectionRefusedException("Unable to connect to AMPS at " + addr.getHost() + ":" + addr.getPort(), ex);
        }
        finally {
            this._lock.unlock();
        }
    }

    protected Socket createSocket() throws Exception {
        return SocketFactory.getDefault().createSocket();
    }

    protected void handshake() throws Exception {
    }

    private void applySocketProperties(Properties properties_) throws SocketException, InvalidURIException {
        this._socket.setKeepAlive(true);
        this._socket.setSoLinger(true, 10);
        if (properties_ == null) {
            return;
        }
        for (Map.Entry<Object, Object> entry : properties_.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if ("tcp_keepalive".equals(key)) {
                if ("false".equals(value)) {
                    this._socket.setKeepAlive(false);
                    continue;
                }
                if ("true".equals(value)) {
                    this._socket.setKeepAlive(true);
                    continue;
                }
                throw new InvalidURIException("Invalid value for tcp_keepalive.");
            }
            if ("tcp_sndbuf".equals(key)) {
                try {
                    int sndbuf = Integer.parseInt((String)value);
                    this._socket.setSendBufferSize(sndbuf);
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new InvalidURIException("Invalid value for tcp_sndbuf.", ex);
                }
            }
            if ("tcp_rcvbuf".equals(key)) {
                try {
                    int rcvbuf = Integer.parseInt((String)value);
                    this._socket.setReceiveBufferSize(rcvbuf);
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new InvalidURIException("Invalid value for tcp_rcvbuf.", ex);
                }
            }
            if ("tcp_linger".equals(key)) {
                try {
                    int linger = Integer.parseInt((String)value);
                    if (linger == -1) {
                        this._socket.setSoLinger(false, 0);
                        continue;
                    }
                    this._socket.setSoLinger(true, linger);
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new InvalidURIException("Invalid value for tcp_linger.", ex);
                }
            }
            if ("tcp_nodelay".equals(key)) {
                if ("false".equals(value)) {
                    this._socket.setTcpNoDelay(false);
                    continue;
                }
                if ("true".equals(value)) {
                    this._socket.setTcpNoDelay(true);
                    continue;
                }
                throw new InvalidURIException("Invalid value for tcp_nodelay.");
            }
            if ("tcp_connecttimeout".equals(key)) {
                try {
                    int connectTimeout;
                    this._connectTimeout = connectTimeout = Integer.parseInt((String)value);
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new InvalidURIException("Invalid value for tcp_connecttimeout.", ex);
                }
            }
            if ("bind".equals(key)) {
                String addr = (String)value;
                if (addr == null || addr.isEmpty()) continue;
                int port = 0;
                int colon = addr.indexOf(58);
                int openBracket = addr.indexOf(91);
                if (openBracket > -1) {
                    int closeBracket = addr.indexOf(93);
                    if (closeBracket < 0) {
                        throw new InvalidURIException("Invalid ipV6 uri: '" + addr + "' for bind.");
                    }
                    colon = closeBracket + 1;
                    if (colon < addr.length() && colon == 58) {
                        port = Integer.parseInt(addr.substring(colon + 1));
                    }
                    addr = addr.substring(openBracket + 1, closeBracket);
                } else if (colon > 0) {
                    addr = addr.substring(0, colon);
                    port = Integer.parseInt(addr.substring(colon + 1));
                }
                try {
                    this._socket.bind(new InetSocketAddress(addr, port));
                    continue;
                }
                catch (IOException ex) {
                    throw new InvalidURIException("Error binding to " + (String)value, ex);
                }
            }
            if ("pretty".equals(key) || "ip_protocol_prefer".equals(key)) continue;
            throw new InvalidURIException("Unrecognized URI parameter `" + key + "'");
        }
    }

    private void _disconnect() {
        try {
            if (this._addr != null) {
                if (this._readerThread != null) {
                    this._readerThread.stopThread();
                }
                this._socket.close();
                if (this._readerThread != null && !this._readerThread.equals(Thread.currentThread())) {
                    this._readerThread.interrupt();
                    this._readerThread.join();
                }
            }
        }
        catch (SocketException ex) {
            try {
                if (this._exceptionListener != null) {
                    this._exceptionListener.exceptionThrown(ex);
                }
            }
            catch (RuntimeException runtimeException) {}
        }
        catch (IOException ex) {
            try {
                if (this._exceptionListener != null) {
                    this._exceptionListener.exceptionThrown(ex);
                }
            }
            catch (RuntimeException runtimeException) {}
        }
        catch (SecurityException ex) {
            throw new RuntimeException("Security exception while interrupting reader thread.", ex);
        }
        catch (InterruptedException ex) {
            try {
                if (this._exceptionListener != null) {
                    this._exceptionListener.exceptionThrown(ex);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this._addr = null;
    }

    public void disconnect() {
        this._lock.lock();
        try {
            this._disconnecting = true;
            this._disconnect();
        }
        finally {
            this._lock.unlock();
        }
    }

    public void send(ByteBuffer buf) throws DisconnectedException {
        try {
            this._filter.outgoing(buf);
            byte[] array = buf.array();
            int remaining = buf.remaining();
            int position = buf.position() + buf.arrayOffset();
            this._outputStream.write(array, position, remaining);
        }
        catch (NullPointerException ex) {
            throw new DisconnectedException("Socket error while sending message.", ex);
        }
        catch (IOException ioex) {
            throw new DisconnectedException("Socket error while sending message.", ioex);
        }
    }

    public Socket socket() {
        return this._socket;
    }

    public long writeQueueSize() {
        return 0L;
    }

    public long readQueueSize() {
        return 0L;
    }

    public long flush() {
        this._lock.lock();
        try {
            long l = 0L;
            return l;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long flush(long timeout) {
        this._lock.lock();
        try {
            long l = 0L;
            return l;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCloseEvent(int failedVersion, String message, Exception e_) throws RetryOperationException, DisconnectedException {
        this._onDisconnect.preInvoke(failedVersion);
        if (this._readerThread != null && !this._readerThread.equals(Thread.currentThread())) {
            this._lock.lock();
        } else {
            try {
                while (!this._lock.tryLock(100L, TimeUnit.MILLISECONDS)) {
                    if (!Thread.currentThread().isInterrupted()) continue;
                    throw new DisconnectedException("Reconnect is in progress in send thread.");
                }
            }
            catch (InterruptedException e) {
                throw new DisconnectedException("Reconnect already in progress in send thread.", e);
            }
        }
        try {
            if (this._disconnecting) {
                throw new DisconnectedException("Disconnect in progress.");
            }
            if (failedVersion != this._connectionVersion) {
                throw new RetryOperationException("A new connection is available.");
            }
            try {
                this._socket.setSoLinger(true, 0);
            }
            catch (SocketException ex) {
                try {
                    if (this._exceptionListener != null) {
                        this._exceptionListener.exceptionThrown(ex);
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            this._disconnect();
            TCPTransport t = TCPTransport.createTransport(this._messageType);
            t._impl = this;
            try {
                this._onDisconnect.invoke(t, new DisconnectedException(message, e_));
            }
            catch (Exception e) {
                throw new DisconnectedException("Disconnect handler threw an exception", e);
            }
        }
        finally {
            this._lock.unlock();
        }
        if (this._connectionVersion == failedVersion) {
            throw new DisconnectedException("A disconnect occurred, and no disconnect handler successfully reconnected.");
        }
        throw new RetryOperationException("Reconnect successful; retry the operation.");
    }

    public void setReadTimeout(int readTimeoutMillis_) {
        this._readTimeout = readTimeoutMillis_;
    }

    public void setConnectTimeout(int connectTimeoutMillis_) {
        this._connectTimeout = connectTimeoutMillis_;
    }

    public void setIdleRunnable(AMPSRunnable runnable) {
        this._idleRunnable = runnable;
    }

    static class TCPReaderThread
    extends Thread {
        TCPTransportImpl transport = null;
        Protocol messageType = null;
        volatile boolean stopped = false;
        CyclicBarrier barrier = new CyclicBarrier(2);

        TCPReaderThread(TCPTransportImpl transport, Protocol messageType) {
            this.transport = transport;
            this.messageType = messageType;
            this.stopped = false;
            this.setDaemon(TCPTransport.isDaemon());
            this.start();
        }

        public void stopThread() {
            this.stopped = true;
        }

        @Override
        public void run() {
            this.setName(String.format("AMPS Java Client Background Reader Thread %d", Thread.currentThread().getId()));
            if (this.transport._threadCreatedHandler != null) {
                try {
                    this.transport._threadCreatedHandler.invoke();
                }
                catch (Exception e) {
                    try {
                        if (this.transport._exceptionListener != null) {
                            this.transport._exceptionListener.exceptionThrown(e);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    String message = "The ThreadCreatedHandler failed.";
                    this.barrier.reset();
                    try {
                        this.transport.handleCloseEvent(this.transport._connectionVersion, message, new DisconnectedException(message, e));
                    }
                    catch (DisconnectedException | RetryOperationException connectionException) {
                        // empty catch block
                    }
                    return;
                }
            }
            try {
                this.barrier.await();
            }
            catch (InterruptedException | BrokenBarrierException e) {
                Thread.interrupted();
                String message = "The connection attempt was interrupted.";
                try {
                    this.transport.handleCloseEvent(this.transport._connectionVersion, message, new DisconnectedException(message));
                }
                catch (DisconnectedException | RetryOperationException connectionException) {
                    // empty catch block
                }
                return;
            }
            ByteBuffer rfifo = ByteBuffer.allocate(16384);
            ProtocolParser protocolParser = this.messageType.getMessageStream();
            int IDLE_PROCESSING_TIMEOUT = 100;
            long lastIdleProcessing = System.currentTimeMillis();
            long lastReadTime = System.currentTimeMillis();
            while (!this.stopped) {
                long currentTime;
                if (this.transport._idleRunnable != null && (currentTime = System.currentTimeMillis()) - lastIdleProcessing > 100L) {
                    lastIdleProcessing = currentTime;
                    try {
                        this.transport._idleRunnable.run();
                    }
                    catch (Exception e) {
                        try {
                            this.transport._exceptionListener.exceptionThrown(e);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                try {
                    int currentVersion = this.transport._connectionVersion;
                    try {
                        int currentPosition = rfifo.position();
                        int readBytes = this.transport._inputStream.read(rfifo.array(), rfifo.position(), rfifo.remaining());
                        if (readBytes == -1 || readBytes == 0) {
                            String message = "The remote server has closed the connection.";
                            this.transport.handleCloseEvent(currentVersion, message, new DisconnectedException(message));
                            return;
                        }
                        lastReadTime = System.currentTimeMillis();
                        rfifo.position(currentPosition + readBytes);
                    }
                    catch (SocketTimeoutException ioex) {
                        long timeSinceLastRead = System.currentTimeMillis() - lastReadTime;
                        if (this.transport._readTimeout != 0 && timeSinceLastRead > (long)this.transport._readTimeout) {
                            String message = String.format("No activity after %d milliseconds; connection closed by client.", this.transport._readTimeout);
                            this.transport.handleCloseEvent(currentVersion, message, new DisconnectedException(message));
                            return;
                        }
                    }
                    catch (IOException ioex) {
                        if (!this.stopped) {
                            this.transport.handleCloseEvent(currentVersion, "Exception while reading", ioex);
                        }
                        return;
                    }
                    rfifo.flip();
                    if (rfifo.remaining() >= 4) {
                        int size = rfifo.getInt(rfifo.position());
                        this.transport._filter.incoming(rfifo);
                        while (rfifo.remaining() - 4 >= size) {
                            size = rfifo.getInt();
                            try {
                                protocolParser.process(rfifo, size, this.transport._onMessage);
                            }
                            catch (Exception e) {
                                try {
                                    if (this.transport._exceptionListener != null) {
                                        this.transport._exceptionListener.exceptionThrown(e);
                                    }
                                }
                                catch (RuntimeException message) {
                                    // empty catch block
                                }
                            }
                            if (rfifo.remaining() < 4) break;
                            size = rfifo.getInt(rfifo.position());
                        }
                        if (rfifo.capacity() < size + 4) {
                            int newSize;
                            for (newSize = rfifo.capacity(); newSize < size + 4; newSize *= 2) {
                            }
                            ByteBuffer newBuffer = ByteBuffer.allocate(newSize);
                            newBuffer.put(rfifo);
                            rfifo = newBuffer;
                            continue;
                        }
                        TCPReaderThread.compactBuffer(rfifo);
                        continue;
                    }
                    TCPReaderThread.compactBuffer(rfifo);
                    continue;
                }
                catch (Exception e) {
                    try {
                        if (this.stopped || this.transport._exceptionListener == null) continue;
                        this.transport._exceptionListener.exceptionThrown(e);
                    }
                    catch (RuntimeException runtimeException) {
                    }
                    continue;
                }
                break;
            }
            return;
        }

        protected static void compactBuffer(ByteBuffer rfifo) {
            if (rfifo.position() != 0) {
                rfifo.compact();
            } else {
                rfifo.position(rfifo.remaining());
                rfifo.limit(rfifo.capacity());
            }
        }
    }
}

