/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client.fields;

import com.crankuptheamps.client.fields.StringField;
import java.util.ArrayList;
import java.util.zip.CRC32;

public class BookmarkField
extends StringField
implements Cloneable {
    public static final char SEPARATOR_CHAR = '|';
    public static final int MAX_BOOKMARK_LENGTH = 42;
    public static final int MAX_TIMESTAMP_LENGTH = 24;
    public static final int MIN_TIMESTAMP_LENGTH = 10;
    protected final CRC32 c = new CRC32();

    @Override
    protected int getConversionBufInitialSize() {
        return 42;
    }

    protected BookmarkField(byte[] buffer, int position, int length) {
        super(buffer, position, length);
    }

    public BookmarkField() {
    }

    public boolean isTimestamp() {
        return this.length >= 10 && this.buffer[this.position + 8] == 84 && this.buffer[this.position + this.length - 1] == 90;
    }

    public boolean isRange() {
        if (this.length >= 5) {
            int pos = this.position;
            while (this.buffer[pos] == 32) {
                if (++pos < this.position + this.length) continue;
                return false;
            }
            if (this.buffer[pos] == 40 || this.buffer[pos] == 91) {
                pos = this.position + this.length - 1;
            }
            while (this.buffer[pos] == 32) {
                if (--pos > this.position) continue;
                return false;
            }
            if (this.buffer[pos] == 41 || this.buffer[pos] == 93) {
                return true;
            }
        }
        return false;
    }

    public long getPublisherId() {
        if (this.isTimestamp() || this.isRange()) {
            return 0L;
        }
        long result = 0L;
        for (int i = this.position; i < this.position + this.length && this.buffer[i] != 124; ++i) {
            result *= 10L;
            result += (long)(this.buffer[i] - 48);
        }
        return result;
    }

    public long getSequenceNumber() {
        int i;
        if (this.isTimestamp() || this.isRange()) {
            return 0L;
        }
        long result = 0L;
        for (i = this.position; i < this.position + this.length && this.buffer[i] != 124; ++i) {
        }
        ++i;
        while (i < this.position + this.length && this.buffer[i] != 124) {
            result *= 10L;
            result += (long)(this.buffer[i] - 48);
            ++i;
        }
        return result;
    }

    public boolean isBookmarkList() {
        for (int comma = this.position; comma < this.position + this.length; ++comma) {
            if (this.buffer[comma] != 44) continue;
            return true;
        }
        return false;
    }

    public ArrayList<BookmarkField> parseBookmarkList() {
        int comma;
        ArrayList<BookmarkField> bookmarks = new ArrayList<BookmarkField>();
        int start = this.position;
        for (comma = this.position; comma < this.position + this.length; ++comma) {
            if (this.buffer[comma] != 44) continue;
            bookmarks.add(new BookmarkField(this.buffer, start, comma - start));
            start = comma + 1;
        }
        if (comma > start) {
            bookmarks.add(new BookmarkField(this.buffer, start, comma - start));
        }
        return bookmarks;
    }

    @Override
    public int hashCode() {
        this.c.reset();
        this.c.update(this.buffer, this.position, this.length);
        return (int)this.c.getValue();
    }

    public BookmarkField clone() {
        byte[] copy = null;
        if (this.buffer != null) {
            copy = new byte[this.length];
            System.arraycopy(this.buffer, this.position, copy, 0, this.length);
        }
        return new BookmarkField(copy, 0, this.length);
    }

    @Override
    public BookmarkField copy() {
        return this.clone();
    }

    @Override
    public boolean equals(Object object_) {
        return super.equals(object_);
    }
}

