/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client.fields;

import com.crankuptheamps.client.fields.BookmarkField;
import com.crankuptheamps.client.fields.Field;

public class BookmarkRangeField
extends BookmarkField {
    private int _capacity = 0;
    private BookmarkField _start = null;
    private BookmarkField _end = null;
    private int _open = -1;

    @Override
    protected int getConversionBufInitialSize() {
        return 128;
    }

    protected BookmarkRangeField(byte[] buffer, int position, int length) {
        super(buffer, position, length);
        this._capacity = length;
        this.parse();
    }

    public BookmarkRangeField() {
    }

    @Override
    public void copyFrom(Field f) {
        int start;
        if (f == null || f.length == 0) {
            this.length = 0;
            this.position = 0;
            this.notValid();
            return;
        }
        if (this.buffer == null || f.length > this._capacity) {
            this.buffer = new byte[f.length];
            this._capacity = f.length;
        }
        for (start = 0; start < f.length && f.buffer[f.position + start] != 91 && f.buffer[f.position + start] != 40; ++start) {
        }
        if (start < f.length) {
            this.length = f.length - start;
            System.arraycopy(f.buffer, f.position + start, this.buffer, 0, this.length);
            this.position = 0;
            this.parse();
        } else {
            this.length = 0;
            this.notValid();
        }
    }

    public boolean isValid() {
        return this._open >= 0;
    }

    public BookmarkField getStart() {
        return this._start;
    }

    public BookmarkField getEnd() {
        return this._end;
    }

    public boolean isStartInclusive() {
        if (this.isValid()) {
            return this.buffer[this._open] == 91;
        }
        return false;
    }

    public boolean isEndInclusive() {
        if (this.isValid()) {
            return this.buffer[this.position + this.length - 1] == 93;
        }
        return false;
    }

    public boolean isStartExclusive() {
        if (this.isValid()) {
            return this.buffer[this._open] == 40;
        }
        return false;
    }

    public boolean isEndExclusive() {
        if (this.isValid()) {
            return this.buffer[this.position + this.length - 1] == 41;
        }
        return false;
    }

    public void replaceStart(Field start_) {
        this.replaceStart(start_, true);
    }

    public void replaceStart(Field start_, boolean makeExclusive) {
        if (!this.isValid()) {
            return;
        }
        BookmarkField startBm = (BookmarkField)start_;
        if (startBm.getPublisherId() == this._start.getPublisherId() && startBm.getSequenceNumber() <= this._start.getSequenceNumber()) {
            if (makeExclusive && startBm.getSequenceNumber() == this._start.getSequenceNumber()) {
                this.buffer[this.position + this._open] = 40;
            }
            return;
        }
        int newLen = start_.length + this._end.length + 3;
        if (this._capacity >= newLen) {
            if (makeExclusive) {
                this.buffer[this.position + this._open] = 40;
            }
            if (this._open > 0) {
                this.buffer[this.position] = this.buffer[this.position + this._open];
                this._open = 0;
            }
            if (this._end.position < start_.length + 2) {
                int pos = newLen - 1;
                for (int src = this.length - 1; src > this._start.length; --src) {
                    while (this.buffer[this.position + src] == 32) {
                        --src;
                    }
                    this.buffer[this.position + pos] = this.buffer[this.position + src];
                    if (this.buffer[this.position + src] == 58) {
                        this._end.set(this.buffer, start_.length + 2, this._end.length);
                        break;
                    }
                    --pos;
                }
            } else if (this._end.position > start_.length + 2) {
                int pos = start_.length + 2;
                for (int src = this._end.position; src < this.length; ++src) {
                    while (this.buffer[this.position + src] == 32) {
                        ++src;
                    }
                    this.buffer[this.position + pos] = this.buffer[this.position + src];
                    if (this.buffer[this.position + src] == 93 || this.buffer[this.position + src] == 41) {
                        this._end.set(this.buffer, this.position + start_.length + 2, this._end.length);
                        this.buffer[this.position + start_.length + 1] = 58;
                        break;
                    }
                    ++pos;
                }
            }
            this.length = newLen;
            System.arraycopy(start_.buffer, start_.position, this.buffer, this.position + 1, start_.length);
            this._start.set(this.buffer, this.position + 1, start_.length);
        } else {
            this._capacity = Math.max(174, start_.length + this._end.length + 3);
            byte[] tmpBuffer = new byte[this._capacity];
            tmpBuffer[0] = makeExclusive ? 40 : this.buffer[this._open];
            this._open = 0;
            System.arraycopy(start_.buffer, start_.position, tmpBuffer, this.position + 1, start_.length);
            this._start.set(tmpBuffer, 1, start_.length);
            tmpBuffer[start_.length + 1] = 58;
            System.arraycopy(this._end.buffer, this._end.position, tmpBuffer, start_.length + 2, this._end.length);
            this._end.set(tmpBuffer, start_.length + 2, this._end.length);
            tmpBuffer[newLen - 1] = this.buffer[this.length - 1];
            this.set(tmpBuffer, 0, newLen);
        }
    }

    @Override
    public BookmarkRangeField clone() {
        byte[] copy = null;
        if (this.buffer != null) {
            copy = new byte[this.length];
            System.arraycopy(this.buffer, this.position, copy, 0, this.length);
        }
        return new BookmarkRangeField(copy, 0, this.length);
    }

    @Override
    public BookmarkRangeField copy() {
        return this.clone();
    }

    @Override
    public int hashCode() {
        this.c.reset();
        this.c.update(this.buffer, this.position, this.length);
        return (int)this.c.getValue();
    }

    @Override
    public boolean equals(Object object_) {
        if (object_ == null || !(object_ instanceof BookmarkRangeField)) {
            return false;
        }
        BookmarkRangeField rhs = (BookmarkRangeField)object_;
        if (this._start == null && rhs._start != null || this._start != null && rhs._start == null) {
            return false;
        }
        return this.isStartInclusive() == rhs.isStartInclusive() && this.isEndInclusive() == rhs.isEndInclusive() && this._start.equals(rhs._start) && this._end.equals(rhs._end);
    }

    private void notValid() {
        this._start = null;
        this._end = null;
        this._open = -1;
    }

    private void parse() {
        this.notValid();
        boolean foundClose = false;
        boolean foundSeparator = false;
        int end = this.position + this.length;
        block7: for (int pos = this.position; pos < end; ++pos) {
            switch (this.buffer[pos]) {
                case 40: 
                case 91: {
                    if (foundClose || this._open > -1) {
                        this.notValid();
                        return;
                    }
                    this._open = pos;
                    continue block7;
                }
                case 44: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 84: 
                case 90: 
                case 124: {
                    if (foundClose || this._open < 0) {
                        this.notValid();
                        return;
                    }
                    if (foundSeparator) {
                        if (this._end != null) continue block7;
                        this._end = new BookmarkField();
                        this._end.set(this.buffer, pos, end - pos);
                        continue block7;
                    }
                    if (this._start != null) continue block7;
                    this._start = new BookmarkField();
                    this._start.set(this.buffer, pos, end - pos);
                    continue block7;
                }
                case 58: {
                    if (foundClose || this._open < 0 || this._start == null || foundSeparator) {
                        this.notValid();
                        return;
                    }
                    foundSeparator = true;
                    if (pos - this._start.position >= this._start.length) continue block7;
                    this._start.length = pos - this._start.position;
                    continue block7;
                }
                case 41: 
                case 93: {
                    if (foundClose || this._open < 0 || this._end == null) {
                        this.notValid();
                        return;
                    }
                    foundClose = true;
                    this.length = pos - this.position + 1;
                    if (pos - this._end.position >= this._end.length) continue block7;
                    this._end.length = pos - this._end.position;
                    continue block7;
                }
                case 32: {
                    if (this._end != null && pos - this._end.position < this._end.length) {
                        this._end.length = pos - this._end.position;
                        continue block7;
                    }
                    if (this._start == null || pos - this._start.position >= this._start.length) continue block7;
                    this._start.length = pos - this._start.position;
                    continue block7;
                }
                default: {
                    this.notValid();
                    return;
                }
            }
        }
        if (this._end == null || this._start == null || !foundSeparator || !foundClose || this._open < 0) {
            this.notValid();
        }
    }
}

