package com.crankuptheamps;

import com.crankuptheamps.client.*;
import java.util.Date;
import java.text.SimpleDateFormat;

class Agent{
    static String AMPS_URL = "tcp://localhost:9005/amps/nvfix";
    static Client agent = null;

    public static void main(String[] args){
        System.out.println("Starting agent");
        try{
            agent = new Client("Agent");
            agent.connect(AMPS_URL);
            agent.logon();
            AgentMessageHandler mh = new AgentMessageHandler();
            agent.subscribe(mh, "->A$", 10000);

            // Spin here forever until user cancels.
            while (true){ Thread.sleep(100); }
        } catch(Exception ex){
            System.err.println("Agent exception: " + ex.toString());
            ex.printStackTrace();
        }
        System.out.println("Agent exiting");
    }

    static class AgentMessageHandler implements MessageHandler{
        public void invoke(Message m){
            String topic = m.getTopic();
            TopicParse parse = TopicParser.parse(topic);
            System.out.println(
                    "**************************\n" + 
                    "Agent - received message:" + 
                    "\n\t type: " + (parse.type == "<-" ? "response" : "request") +
                    "\n\t message: " + m.getData() + "\n" +
                    "**************************\n");
            try{
                Date d = new Date(); 
                SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy h:mm:ss a");
                String msg = "Response: " + sdf.format(d);
                System.out.println(
                        "**************************\n" + 
                        "Agent - Sending response: " + 
                        "\n\t message: " + msg + "\n" +
                        "**************************\n");
                agent.publish(parse.prefix + "<-" + parse.postfix, msg);
            } catch(Exception ex){
                System.err.println("Agent exception: " + ex.toString());
                ex.printStackTrace();
            }
        }
    }
}
