package com.crankuptheamps;

import com.crankuptheamps.client.*;
import java.util.Date;
import java.text.SimpleDateFormat; 

class Monitor{
    static String AMPS_URL = "tcp://localhost:9005/amps/nvfix";

    public static void main(String[] args) {
        System.out.println("Starting Monitor");

        // Create the listener on the "^M<-.*" topic.
        try{
            Client monitorClient = new Client("monitor");
            monitorClient.connect(AMPS_URL);
            monitorClient.logon();
            MonitorMessageHandler mh = new MonitorMessageHandler();
            monitorClient.subscribe(mh, "^M<-.*", 10000);

            // Create the monitor that will publish messages once per second.
            String msg = "";
            while (true) {
                Date d = new Date(); 
                SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy h:mm:ss a");
                msg = "Heartbeat!  Timestamp: " + sdf.format(d);
                System.out.println(
                        "**************************\n" + 
                        "Monitor - sending message:" + 
                        "\n\tmessage: " + msg + "\n" + 
                        "**************************\n");
                monitorClient.publish("M->A", msg);
                Thread.sleep(1000);
            }
        } catch(Exception ex){
            System.err.println("monitor exception: " + ex.toString());
            ex.printStackTrace();
        }
        System.out.println("Monitor exiting");
    }

    static class MonitorMessageHandler implements MessageHandler{
        public void invoke(Message m){
            String topic = m.getTopic();
            TopicParse parse = TopicParser.parse(topic);
            System.out.println(
                    "**************************\n" + 
                    "Monitor - received message:" + 
                    "\n\t type: " + (parse.type == "<-" ? "response" : "request") +
                    "\n\t message: " + m.getData() + "\n" +
                    "**************************\n");

        }
    }
}

