/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.BookmarkStore;
import com.crankuptheamps.client.BookmarkStoreResizeHandler;
import com.crankuptheamps.client.fields.BookmarkField;
import com.crankuptheamps.client.fields.Field;

public class BookmarkRingBuffer {
    final int INITIAL_ENTRY_COUNT = 1000;
    public static final int UNSET_INDEX = -1;
    Entry[] _entries = new Entry[1000];
    int _start = 0;
    int _end = 0;
    int _recovery = -1;
    int _recoveryMax = -1;
    long _index = 0L;
    long _indexOfStart = 0L;
    long _indexOfRecovery = -1L;
    BookmarkField _lastDiscarded = new BookmarkField();
    boolean _persistedAcks = true;
    boolean _empty = true;
    BookmarkStoreResizeHandler _resizeHandler;
    BookmarkStore _store;
    Field _subId;

    public BookmarkRingBuffer() {
        this._lastDiscarded.set("0".getBytes());
        for (int i = 0; i < this._entries.length; ++i) {
            this._entries[i] = new Entry();
        }
    }

    public int capacity() {
        return this._entries.length;
    }

    public Entry getByIndex(long index) {
        int offsetFromStart = 0;
        if (this._recovery == -1) {
            if (index < this._indexOfStart + (long)this._start) {
                return null;
            }
            offsetFromStart = (int)(index - this._indexOfStart) % this._entries.length;
        } else {
            if (index < (long)this._recovery + this._indexOfRecovery) {
                return null;
            }
            offsetFromStart = (int)(index - this._indexOfRecovery) % this._entries.length;
        }
        return this._entries[offsetFromStart];
    }

    public BookmarkField getLastDiscarded() {
        return this._lastDiscarded;
    }

    public boolean isEmpty() {
        return this._empty;
    }

    public long getStartIndex() {
        if (this._empty) {
            return -1L;
        }
        return this._indexOfStart + (long)this._start;
    }

    public long getEndIndex() {
        if (this._empty) {
            return -1L;
        }
        return this._index;
    }

    public long log(BookmarkField bookmark) {
        int min;
        this._empty = false;
        int writeIndex = this._end++;
        this._entries[writeIndex].setBookmark(bookmark).setActive(true).setPersisted(!this._persistedAcks);
        if (this._end == this._entries.length) {
            this._end = 0;
        }
        int n = min = this._recovery == -1 ? this._start : this._recovery;
        while (this._end == min) {
            this.resize();
            min = this._recovery == -1 ? this._start : this._recovery;
        }
        return this._index++;
    }

    public long relog(long oldIndex, BookmarkField bookmark) {
        int min;
        long baseIndex;
        this._empty = false;
        int writeIndex = this._end++;
        long l = baseIndex = this._indexOfRecovery == -1L ? this._indexOfStart : this._indexOfRecovery;
        if (oldIndex < baseIndex) {
            oldIndex += (long)this._entries.length;
        }
        int offsetFromStart = (int)(oldIndex - baseIndex) % this._entries.length;
        Entry current = this._entries[offsetFromStart];
        this._entries[writeIndex].setBookmark(bookmark).setActive(current.isActive()).setPersisted(current.isPersisted() || !this._persistedAcks);
        current.setActive(false).setPersisted(true).getBookmark().reset();
        this.resetRecovery();
        if (this._end == this._entries.length) {
            this._end = 0;
        }
        int n = min = this._recovery == -1 ? this._start : this._recovery;
        while (this._end == min) {
            this.resize();
            min = this._recovery == -1 ? this._start : this._recovery;
        }
        return this._index++;
    }

    public boolean discard(long index) {
        Entry lastDiscardedEntry;
        long minIndex = 0L;
        minIndex = this._recovery == -1 ? this._indexOfStart : this._indexOfRecovery;
        if (index < minIndex || index > this._index) {
            return false;
        }
        int offsetFromStart = (int)(index - minIndex);
        int indexInArray = offsetFromStart % this._entries.length;
        this._entries[indexInArray].setActive(false);
        if (this._start == indexInArray) {
            Entry lastDiscardedEntry2 = null;
            while (!(this._entries[this._start].isActive() || !this._entries[this._start].isPersisted() || this._start == this._end && this._empty)) {
                if (lastDiscardedEntry2 != null) {
                    lastDiscardedEntry2.getBookmark().reset();
                }
                lastDiscardedEntry2 = this._entries[this._start];
                if (++this._start == this._entries.length) {
                    this._start = 0;
                    this._indexOfStart += (long)this._entries.length;
                }
                this._empty = this._start == this._end;
            }
            if (lastDiscardedEntry2 != null) {
                this._lastDiscarded.copyFrom(lastDiscardedEntry2.getBookmark());
                lastDiscardedEntry2.getBookmark().reset();
                return true;
            }
        } else if (this._recovery == indexInArray && (lastDiscardedEntry = this.resetRecovery()) != null) {
            this._lastDiscarded.copyFrom(lastDiscardedEntry.getBookmark());
            lastDiscardedEntry.getBookmark().reset();
            return true;
        }
        return false;
    }

    private Entry resetRecovery() {
        if (this._recovery == -1) {
            return null;
        }
        Entry lastDiscardedEntry = null;
        while (!this._entries[this._recovery].isActive() && this._entries[this._recovery].isPersisted()) {
            if (this._start == this._end) {
                if (lastDiscardedEntry != null) {
                    lastDiscardedEntry.getBookmark().reset();
                }
                lastDiscardedEntry = this._entries[this._recovery];
            }
            if (this._recovery == this._recoveryMax) {
                this._recovery = -1;
                this._indexOfRecovery = -1L;
                this._recoveryMax = -1;
                this._empty = this._start == this._end;
                break;
            }
            if (++this._recovery != this._entries.length) continue;
            this._recovery = 0;
            this._indexOfRecovery += (long)this._entries.length;
        }
        return lastDiscardedEntry;
    }

    public Entry find(BookmarkField field) {
        if (this._empty) {
            return null;
        }
        long index = this._indexOfStart + (long)this._start;
        int i = this._start;
        do {
            if (!this._entries[i].getBookmark().isNull() && this._entries[i].getBookmark().equals(field)) {
                return this._entries[i].setIndex(index);
            }
            ++index;
        } while ((i = (i + 1) % this._entries.length) != this._end);
        return null;
    }

    public void persisted(BookmarkField bookmark) {
        Entry safeEntry = this.find(bookmark);
        if (safeEntry == null) {
            return;
        }
        long last = safeEntry.getIndex();
        this.persisted(last);
    }

    public void persisted(long bookmark) {
        if (bookmark < this.getStartIndex() || bookmark > this.getEndIndex()) {
            return;
        }
        boolean foundActive = false;
        Entry lastDiscardedEntry = null;
        long startIndex = this._indexOfStart;
        int idx = this._start;
        while ((long)idx + startIndex <= bookmark) {
            this._entries[idx].setPersisted(true);
            if (!foundActive) {
                if (!this._entries[idx].isActive() && !this._entries[idx].getBookmark().isNull()) {
                    if (lastDiscardedEntry != null) {
                        lastDiscardedEntry.getBookmark().reset();
                    }
                    lastDiscardedEntry = this._entries[idx];
                    ++this._start;
                } else {
                    foundActive = true;
                }
            }
            if (++idx != this._entries.length) continue;
            if (this._start == idx) {
                this._start = 0;
                this._indexOfStart += (long)this._entries.length;
            }
            startIndex += (long)this._entries.length;
            idx = 0;
        }
        if (lastDiscardedEntry != null) {
            this._lastDiscarded.copyFrom(lastDiscardedEntry.getBookmark());
            lastDiscardedEntry.getBookmark().reset();
        }
        this._empty = this._start == this._end;
    }

    public void noPersistedAcks() {
        this._persistedAcks = false;
        this.persisted(this._index);
    }

    public void setPersistedAcks() {
        this._persistedAcks = true;
    }

    public boolean persistedAcks() {
        return this._persistedAcks;
    }

    private void resize() {
        int oldLength = this._entries.length;
        if (this._resizeHandler != null && !this._resizeHandler.invoke(this._store, this._subId, (int)((double)oldLength * 1.5))) {
            return;
        }
        Entry[] newEntries = new Entry[(int)((double)oldLength * 1.5)];
        int start = this._recovery == -1 ? this._start : this._recovery;
        System.arraycopy(this._entries, start, newEntries, 0, oldLength - start);
        if (start > 0) {
            System.arraycopy(this._entries, 0, newEntries, oldLength - start, start);
        }
        if (this._recovery != -1) {
            this._indexOfStart += (long)this._recovery;
            this._indexOfRecovery += (long)this._recovery;
            this._start -= this._recovery;
            if (this._start < 0) {
                this._start += this._entries.length;
            }
            this._recoveryMax -= this._recovery;
            this._recovery = 0;
        } else {
            this._indexOfStart += (long)this._start;
            this._start = 0;
        }
        this._end = oldLength;
        for (int i = oldLength; i < newEntries.length; ++i) {
            newEntries[i] = new Entry();
        }
        this._entries = newEntries;
    }

    public void setResizeHandler(BookmarkStoreResizeHandler handler, BookmarkStore store) {
        this._resizeHandler = handler;
        this._store = store;
    }

    public void setSubId(Field sub) {
        this._subId = sub.copy();
    }

    public long setRecovery() {
        if (this._recovery == -1) {
            if (this._empty) {
                return -1L;
            }
            this._recovery = this._start;
            this._indexOfRecovery = this._indexOfStart;
        }
        this._recoveryMax = this._end - 1;
        if (this._recoveryMax < 0) {
            this._recoveryMax = this._entries.length - 1;
        }
        if (this._end < this._start) {
            this._indexOfStart += (long)this._entries.length;
        }
        this._start = this._end;
        return (long)this._recovery + this._indexOfRecovery;
    }

    public class Entry {
        BookmarkField _bookmark = new BookmarkField();
        long _index = 0L;
        boolean _active = false;
        boolean _persisted = false;

        public Entry setBookmark(Field f) {
            this._bookmark.copyFrom(f);
            return this;
        }

        public BookmarkField getBookmark() {
            return this._bookmark;
        }

        public Entry setIndex(long index) {
            this._index = index;
            return this;
        }

        public long getIndex() {
            return this._index;
        }

        public boolean isActive() {
            return this._active;
        }

        public Entry setActive(boolean active) {
            this._active = active;
            return this;
        }

        public boolean isPersisted() {
            return this._persisted;
        }

        public Entry setPersisted(boolean persisted) {
            this._persisted = persisted;
            return this;
        }
    }
}

