/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.BookmarkRingBuffer;
import com.crankuptheamps.client.BookmarkStore;
import com.crankuptheamps.client.BookmarkStoreResizeHandler;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.Pool;
import com.crankuptheamps.client.exception.AMPSException;
import com.crankuptheamps.client.fields.BookmarkField;
import com.crankuptheamps.client.fields.Field;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MemoryBookmarkStore
implements BookmarkStore {
    HashMap<Field, Subscription> _subs = new HashMap();
    BookmarkStoreResizeHandler _resizeHandler = null;
    private int _serverVersion = 4000000;
    Pool<Subscription> _pool;

    public MemoryBookmarkStore() {
        this._pool = new Pool<Subscription>(Subscription.class, 1);
    }

    public MemoryBookmarkStore(int targetNumberOfSubscriptions) {
        this._pool = new Pool<Subscription>(Subscription.class, targetNumberOfSubscriptions);
    }

    public long log(Message message) throws AMPSException {
        BookmarkField bookmark = message.getBookmarkRaw();
        Subscription sub = (Subscription)message.getSubscription();
        if (sub == null) {
            Field subId = message.getSubIdRaw();
            if (subId == null || subId.isNull()) {
                subId = message.getSubIdsRaw();
            }
            sub = this.find(subId);
            message.setSubscription(sub);
        }
        long seqNo = sub.log(bookmark);
        message.setBookmarkSeqNo(seqNo);
        return seqNo;
    }

    public void discard(Field subId, long bookmarkSeqNo) throws AMPSException {
        this.find(subId).discard(bookmarkSeqNo);
    }

    public void discard(Message message) throws AMPSException {
        long bookmark = message.getBookmarkSeqNo();
        Subscription sub = (Subscription)message.getSubscription();
        if (sub == null) {
            Field subId = message.getSubIdRaw();
            if (subId == null || subId.isNull()) {
                subId = message.getSubIdsRaw();
            }
            sub = this.find(subId);
            message.setSubscription(sub);
        }
        sub.discard(bookmark);
    }

    public Field getMostRecent(Field subId) throws AMPSException {
        if (this._serverVersion >= 4000000) {
            return this.find(subId).getMostRecentList();
        }
        return this.find(subId).getMostRecent();
    }

    public boolean isDiscarded(Message message) throws AMPSException {
        BookmarkField bookmark = message.getBookmarkRaw();
        Subscription sub = (Subscription)message.getSubscription();
        if (sub == null) {
            Field subId = message.getSubIdRaw();
            if (subId == null || subId.isNull()) {
                subId = message.getSubIdsRaw();
            }
            sub = this.find(subId);
            message.setSubscription(sub);
        }
        return sub.isDiscarded(bookmark);
    }

    public void persisted(Field subId, long bookmark) throws AMPSException {
        if (this._serverVersion >= 4000000) {
            this.find(subId).setLastPersisted(bookmark);
        } else {
            this.find(subId).persisted(bookmark);
        }
    }

    public void persisted(Field subId, BookmarkField bookmark) throws AMPSException {
        if (this._serverVersion >= 4000000) {
            this.find(subId).setLastPersisted(bookmark);
        } else {
            this.find(subId).persisted(bookmark);
        }
    }

    public void noPersistedAcks(Field subId) throws AMPSException {
        this.find(subId).noPersistedAcks();
    }

    private synchronized Subscription find(Field subId) {
        Subscription s = this._subs.get(subId);
        if (s == null) {
            s = this._pool.get();
            s.setSubscription(subId);
            s.setResizeHandler(this._resizeHandler, this);
            if (this._serverVersion >= 4000000 || this._serverVersion < 3080000) {
                s.noPersistedAcks();
            }
            this._subs.put(subId.copy(), s);
        }
        return s;
    }

    public synchronized void purge() throws AMPSException {
        this._subs = new HashMap();
    }

    public synchronized long getOldestBookmarkSeq(Field subId) throws AMPSException {
        long retVal = 0L;
        retVal = this.find(subId).getOldestBookmarkSeq();
        return retVal;
    }

    public void setResizeHandler(BookmarkStoreResizeHandler handler) {
        this._resizeHandler = handler;
        for (Map.Entry<Field, Subscription> pairs : this._subs.entrySet()) {
            pairs.getValue().setResizeHandler(handler, this);
        }
    }

    public void setServerVersion(int version) {
        if (this._serverVersion == version) {
            return;
        }
        this._serverVersion = version;
        if (this._serverVersion >= 4000000 || this._serverVersion < 3080000) {
            for (Map.Entry<Field, Subscription> pairs : this._subs.entrySet()) {
                pairs.getValue().noPersistedAcks();
            }
        } else {
            for (Map.Entry<Field, Subscription> pairs : this._subs.entrySet()) {
                pairs.getValue().setPersistedAcks();
            }
        }
    }

    static class Subscription
    implements com.crankuptheamps.client.Subscription {
        Field _sub;
        private BookmarkField _lastPersisted;
        BookmarkRingBuffer _ring = new BookmarkRingBuffer();
        HashMap<Field, Long> _recovered = new HashMap();
        HashMap<Long, Long> _publishers = new HashMap();
        HashMap<Long, Long> _relocatedActiveBookmarks = new HashMap();

        public Subscription(Field subscriptionId) {
            this._sub = subscriptionId.copy();
            this._ring.setSubId(this._sub);
        }

        public Subscription() {
        }

        public void setSubscription(Field subId) {
            this._sub = subId.copy();
            this._ring.setSubId(this._sub);
        }

        public synchronized long log(BookmarkField bookmark) {
            Long recoveredValue = this._recovered.remove(bookmark);
            if (recoveredValue != null) {
                long index = this._ring.relog(recoveredValue, bookmark);
                this._relocatedActiveBookmarks.put(recoveredValue, index);
                return index;
            }
            return this._ring.log(bookmark);
        }

        public synchronized void discard(long index) {
            long idx = index;
            Long newIndex = this._relocatedActiveBookmarks.remove(index);
            while (newIndex != null) {
                this._ring.discard(idx);
                idx = newIndex;
                newIndex = this._relocatedActiveBookmarks.remove(newIndex);
            }
            this._ring.discard(idx);
        }

        public synchronized boolean isDiscarded(BookmarkField bookmark) {
            Long recoveredIndex = this._recovered.get(bookmark);
            if (recoveredIndex != null) {
                boolean active;
                BookmarkRingBuffer.Entry entry = this._ring.getByIndex(recoveredIndex);
                boolean bl = active = entry == null ? false : entry.isActive();
                if (active) {
                    return false;
                }
                if ((entry == null || !entry.isActive() && entry.isPersisted()) && this._ring.getStartIndex() == -1L) {
                    this._ring.discard(recoveredIndex);
                } else {
                    long newIndex = this._ring.relog(recoveredIndex, bookmark);
                    if (active) {
                        this._relocatedActiveBookmarks.put(recoveredIndex, newIndex);
                    }
                }
                this._recovered.remove(bookmark);
                return true;
            }
            long publisher = bookmark.getPublisherId();
            long sequence = bookmark.getSequenceNumber();
            if (!this._publishers.containsKey(publisher) || this._publishers.get(publisher) < sequence) {
                this._publishers.put(publisher, sequence);
                return false;
            }
            BookmarkRingBuffer.Entry entry = this._ring.find(bookmark);
            if (entry != null) {
                return !entry.isActive();
            }
            return true;
        }

        public synchronized Field getMostRecent() {
            this.updateRecovery();
            return this._ring.getLastDiscarded();
        }

        public synchronized Field getMostRecentList() {
            this.updateRecovery();
            BookmarkField lastDiscarded = this._ring.getLastDiscarded();
            boolean useLastDiscarded = lastDiscarded != null && !lastDiscarded.isNull();
            long lastDiscardedPub = 0L;
            long lastDiscardedSeq = 0L;
            boolean useLastPersisted = this._lastPersisted != null && !this._lastPersisted.isNull();
            long lastPersistedPub = 0L;
            long lastPersistedSeq = 0L;
            if (useLastPersisted) {
                lastPersistedPub = this._lastPersisted.getPublisherId();
                lastPersistedSeq = this._lastPersisted.getSequenceNumber();
            }
            if (useLastDiscarded) {
                if (this._ring.isEmpty() && useLastPersisted) {
                    useLastDiscarded = false;
                } else {
                    lastDiscardedPub = lastDiscarded.getPublisherId();
                    lastDiscardedSeq = lastDiscarded.getSequenceNumber();
                    if (useLastPersisted && lastPersistedPub == lastDiscardedPub && lastPersistedSeq < lastDiscardedSeq) {
                        useLastPersisted = lastPersistedSeq < lastDiscardedSeq;
                        useLastDiscarded = !useLastPersisted;
                    }
                }
            }
            StringBuilder recentStr = new StringBuilder();
            if (useLastDiscarded) {
                recentStr.append(lastDiscarded.getValue(Charset.forName("ISO-8859-1").newDecoder()));
            }
            if (!useLastPersisted && !useLastDiscarded) {
                if (this._publishers.isEmpty()) {
                    this._lastPersisted.setValue("0", Charset.forName("ISO-8859-1").newEncoder());
                    return this._lastPersisted;
                }
                Iterator<Map.Entry<Long, Long>> it = this._publishers.entrySet().iterator();
                while (it.hasNext()) {
                    if (recentStr.length() > 0) {
                        recentStr.append(",");
                    }
                    Map.Entry<Long, Long> pairs = it.next();
                    long pubId = pairs.getKey();
                    long seq = pairs.getValue();
                    recentStr.append(pubId).append("|");
                    recentStr.append(seq).append("|");
                }
            }
            if (useLastPersisted) {
                if (recentStr.length() > 0) {
                    recentStr.append(",");
                }
                recentStr.append(this._lastPersisted.getValue(Charset.forName("ISO-8859-1").newDecoder()));
            }
            BookmarkField recentList = new BookmarkField();
            recentList.setValue(recentStr.toString(), Charset.forName("ISO-8859-1").newEncoder());
            return recentList;
        }

        private void updateRecovery() {
            long end = this._ring.getEndIndex();
            for (long index = this._ring.setRecovery(); index < end; ++index) {
                BookmarkRingBuffer.Entry entry = this._ring.getByIndex(index);
                if (!entry.isActive() && entry.isPersisted()) continue;
                this._recovered.put(entry.getBookmark(), index);
            }
        }

        public synchronized void persisted(long bookmark) {
            this._ring.persisted(bookmark);
        }

        public synchronized void persisted(BookmarkField bookmark) {
            this._ring.persisted(bookmark);
        }

        public synchronized void setLastPersisted(long bookmark) {
            BookmarkRingBuffer.Entry entry = this._ring.getByIndex(bookmark);
            if (entry == null) {
                return;
            }
            if (this._lastPersisted != null) {
                this._lastPersisted.reset();
            }
            this._lastPersisted = entry.getBookmark().copy();
        }

        public synchronized void setLastPersisted(BookmarkField bookmark) {
            if (!this._ring.persistedAcks() && this._lastPersisted != null && bookmark.getPublisherId() == this._lastPersisted.getPublisherId() && bookmark.getSequenceNumber() <= this._lastPersisted.getSequenceNumber()) {
                return;
            }
            if (this._lastPersisted != null) {
                this._lastPersisted.reset();
            }
            this._lastPersisted = bookmark.copy();
        }

        public synchronized void noPersistedAcks() {
            this._ring.noPersistedAcks();
        }

        public synchronized void setPersistedAcks() {
            this._ring.setPersistedAcks();
        }

        public synchronized long getOldestBookmarkSeq() {
            return this._ring.getStartIndex();
        }

        public void setResizeHandler(BookmarkStoreResizeHandler handler, BookmarkStore store) {
            this._ring.setResizeHandler(handler, store);
        }
    }
}

