/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.BlockPublishStore;
import com.crankuptheamps.client.PublishStoreResizeHandler;
import com.crankuptheamps.client.Store;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MemoryStoreBuffer
implements BlockPublishStore.Buffer {
    protected ByteBuffer _buffer = null;
    protected PublishStoreResizeHandler _resizeHandler = null;
    protected Store _store = null;

    public long getSize() throws IOException {
        return this._buffer == null ? 0L : (long)this._buffer.capacity();
    }

    public void setSize(long newSize) throws IOException {
        if (this._resizeHandler != null && !this._resizeHandler.invoke(this._store, newSize)) {
            return;
        }
        if (this._buffer == null || newSize > (long)this._buffer.capacity()) {
            ByteBuffer b2 = ByteBuffer.allocate((int)newSize);
            if (this._buffer != null) {
                b2.put(this._buffer.array());
            }
            this._buffer = b2;
        }
    }

    public long getPosition() throws IOException {
        return this._buffer.position();
    }

    public void setPosition(long position) throws IOException {
        this._buffer.position((int)position);
    }

    public void putByte(byte b) throws IOException {
        this._buffer.put(b);
    }

    public byte getByte() throws IOException {
        return this._buffer.get();
    }

    public void putInt(int i) throws IOException {
        this._buffer.putInt(i);
    }

    public int getInt() throws IOException {
        return this._buffer.getInt();
    }

    public void putLong(long l) throws IOException {
        this._buffer.putLong(l);
    }

    public long getLong() throws IOException {
        return this._buffer.getLong();
    }

    public void putBytes(BlockPublishStore.ByteSequence bytes) throws IOException {
        this._buffer.put(bytes.array, (int)bytes.offset, (int)bytes.len);
    }

    public void getBytes(BlockPublishStore.ByteSequence outBytes) throws IOException {
        if (this._buffer.hasArray()) {
            outBytes.array = this._buffer.array();
            outBytes.offset = this._buffer.position();
            this._buffer.position((int)(outBytes.offset + outBytes.len));
        } else {
            outBytes.array = new byte[(int)outBytes.len];
            outBytes.offset = 0L;
            this._buffer.get(outBytes.array, 0, (int)outBytes.len);
        }
    }

    public void zero(long offset, int length) throws IOException {
        for (long i = 0L; i < (long)length; i += 8L) {
            this._buffer.putLong((int)offset + (int)i, 0L);
        }
    }

    public void setResizeHandler(PublishStoreResizeHandler handler, Store store) {
        this._resizeHandler = handler;
        this._store = store;
    }
}

