/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.CommandId;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.MessageHandler;
import java.util.concurrent.ConcurrentHashMap;

public class MessageRouter {
    ConcurrentHashMap<CommandId, MessageRoute> _routes = new ConcurrentHashMap();
    CommandId _key = new CommandId();

    public void addRoute(CommandId commandId_, MessageHandler messageHandler_, int requestedAcks_, int systemAcks_, boolean isSubscribe_) {
        this._routes.put(commandId_, new MessageRoute(messageHandler_, requestedAcks_, systemAcks_, isSubscribe_));
    }

    public boolean removeRoute(CommandId commandId_) {
        return this._routes.remove(commandId_) != null;
    }

    public MessageHandler findRoute(CommandId commandId_) {
        MessageRoute route = this._routes.get(commandId_);
        if (route != null) {
            return route.getMessageHandler();
        }
        return null;
    }

    public void clear() {
        this._routes.clear();
    }

    public int deliverAck(Message ackMessage_, int ackType_) throws Exception {
        assert (ackMessage_.getCommand() == 65536);
        assert (ackType_ != 0);
        int messagesDelivered = 0;
        if (ackMessage_.getCommandId(this._key)) {
            messagesDelivered += this._deliverAck(ackMessage_, ackType_, this._key);
        }
        if (ackMessage_.getQueryId(this._key)) {
            if (messagesDelivered == 0) {
                messagesDelivered += this._deliverAck(ackMessage_, ackType_, this._key);
            } else {
                this._processAckForRemoval(ackType_, this._key);
            }
        }
        if (ackMessage_.getSubId(this._key)) {
            if (messagesDelivered == 0) {
                messagesDelivered += this._deliverAck(ackMessage_, ackType_, this._key);
            } else {
                this._processAckForRemoval(ackType_, this._key);
            }
        }
        return messagesDelivered;
    }

    public int deliverData(Message dataMessage_) throws Exception {
        assert (dataMessage_.getCommand() != 65536);
        int messagesDelivered = 0;
        if (messagesDelivered == 0 && dataMessage_.getQueryId(this._key)) {
            messagesDelivered += this.deliverData(dataMessage_, this._key);
        }
        if (dataMessage_.getCommandId(this._key)) {
            messagesDelivered += this.deliverData(dataMessage_, this._key);
        }
        if (messagesDelivered == 0 && dataMessage_.getSubId(this._key)) {
            messagesDelivered += this.deliverData(dataMessage_, this._key);
        }
        return messagesDelivered;
    }

    public int deliverData(Message dataMessage_, CommandId commandId_) throws Exception {
        assert (dataMessage_.getCommand() != 65536);
        int messagesDelivered = 0;
        MessageRoute route = this._routes.get(commandId_);
        if (route != null) {
            messagesDelivered += route.deliverData(dataMessage_);
        }
        return messagesDelivered;
    }

    private int _deliverAck(Message ackMessage_, int ackType_, CommandId commandId_) throws Exception {
        int messagesDelivered = 0;
        MessageRoute route = this._routes.get(commandId_);
        if (route != null) {
            messagesDelivered += route.deliverAck(ackMessage_, ackType_);
            if (route.isTerminationAck(ackType_)) {
                this._routes.remove(commandId_);
            }
        }
        return messagesDelivered;
    }

    private void _processAckForRemoval(int ackType_, CommandId commandId_) {
        MessageRoute route = this._routes.get(commandId_);
        if (route != null && route.isTerminationAck(ackType_)) {
            this._routes.remove(commandId_);
        }
    }

    private static class MessageRoute {
        MessageHandler _messageHandler;
        int _systemAcks;
        int _terminationAck = 0;

        public MessageRoute(MessageHandler messageHandler_, int requestedAcks_, int systemAcks_, boolean isSubscribe_) {
            this._messageHandler = messageHandler_;
            this._systemAcks = systemAcks_;
            if (!isSubscribe_) {
                for (int bitCounter = requestedAcks_; bitCounter > 0; bitCounter >>= 1) {
                    this._terminationAck = this._terminationAck > 0 ? 2 * this._terminationAck : 1;
                }
            }
        }

        public int deliverAck(Message message_, int ackType_) throws Exception {
            if ((this._systemAcks & ackType_) != 0) {
                return 0;
            }
            this._messageHandler.invoke(message_);
            return 1;
        }

        public boolean isTerminationAck(int ackType_) {
            return ackType_ == this._terminationAck;
        }

        public int deliverData(Message message_) throws Exception {
            this._messageHandler.invoke(message_);
            return 1;
        }

        public MessageHandler getMessageHandler() {
            return this._messageHandler;
        }
    }
}

