/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.Client;
import com.crankuptheamps.client.CommandId;
import com.crankuptheamps.client.ConnectionStateListener;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.MessageHandler;
import java.io.Closeable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageStream
implements Iterator<Message>,
Iterable<Message>,
MessageHandler,
ConnectionStateListener,
Closeable {
    CommandId _commandId;
    Client _client;
    ConcurrentLinkedQueue<Message> _q = new ConcurrentLinkedQueue();
    Message _current = null;
    final int STATE_Unset = 0;
    final int STATE_Reading = 16;
    final int STATE_Subscribed = 17;
    final int STATE_SOWOnly = 18;
    final int STATE_StatsOnly = 19;
    final int STATE_Disconnected = 1;
    final int STATE_Complete = 2;
    int _state = 0;

    protected MessageStream(Client client_) {
        this._client = client_;
        this._client.addConnectionStateListener(this);
    }

    protected void setSubscription(CommandId commandId_) {
        this._commandId = commandId_;
        this._state = 17;
    }

    protected void setSOWOnly() {
        this._state = 18;
    }

    protected void setStatsOnly() {
        this._state = 19;
    }

    protected void setRunning() {
        this._state = 16;
    }

    @Override
    public void connectionStateChanged(int newState_) {
        if (newState_ == 0) {
            this._state = 1;
        }
    }

    @Override
    public boolean hasNext() {
        if (this._current != null) {
            return true;
        }
        this._current = this._q.poll();
        while ((this._state & 0x10) > 0 && this._current == null) {
            Thread.yield();
            this._current = this._q.poll();
        }
        return this._current != null;
    }

    @Override
    public Message next() {
        if (this._current == null) {
            this.hasNext();
        }
        Message retVal = this._current;
        this._current = null;
        if (this._state == 18 && retVal != null && retVal.getCommand() == 16384) {
            this._state = 2;
        } else if (this._state == 19 && retVal != null && retVal.getAckType() == 32) {
            this._state = 2;
        }
        return retVal;
    }

    @Override
    public void invoke(Message message) {
        this._q.add(message.copy());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Message> iterator() {
        return this;
    }

    public boolean isConnected() {
        return this._state != 1;
    }

    @Override
    public void close() {
        try {
            if (this._client != null) {
                this._client.removeConnectionStateListener(this);
                if (this._state == 17 && this._commandId != null) {
                    this._client.unsubscribe(this._commandId);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this._state = 2;
    }
}

