/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.exception.CommandException;
import java.io.UnsupportedEncodingException;

public class NVFIXBuilder {
    private byte[] buffer = null;
    private int size = 0;
    private int capacity = 1024;
    private byte fieldSeparator;

    public NVFIXBuilder(int capacity, byte fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
        this.capacity = capacity;
        this.buffer = new byte[capacity];
    }

    public void clear() {
        this.size = 0;
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getBytes() {
        return this.buffer;
    }

    private void checkCapacity(int bytesNeeded) {
        if (this.capacity - this.size < bytesNeeded) {
            while (this.capacity - this.size < bytesNeeded) {
                this.capacity *= 2;
            }
            byte[] newbuf = new byte[this.capacity];
            System.arraycopy(this.buffer, 0, newbuf, 0, this.size);
            this.buffer = newbuf;
        }
    }

    public NVFIXBuilder append(String tag, byte[] value, int offset, int length) throws CommandException {
        byte[] tagBytes;
        try {
            tagBytes = tag.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException ioex) {
            throw new CommandException("Unable to encode tag '" + tag + "' to a byte array in FIXBuilder.\n" + ioex.toString());
        }
        int sizeNeeded = tagBytes.length + length + 2;
        this.checkCapacity(sizeNeeded);
        int writeIndex = this.size;
        System.arraycopy(tagBytes, 0, this.buffer, writeIndex, tagBytes.length);
        this.buffer[writeIndex += tagBytes.length] = 61;
        System.arraycopy(value, offset, this.buffer, ++writeIndex, length);
        this.buffer[writeIndex += length] = this.fieldSeparator;
        this.size += sizeNeeded;
        return this;
    }

    public NVFIXBuilder append(String tag, String value) throws CommandException {
        byte[] valueBytes;
        byte[] tagBytes;
        try {
            tagBytes = tag.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException ioex) {
            throw new CommandException("Unable to encode tag '" + tag + "' to a byte array in FIXBuilder.\n" + ioex.toString());
        }
        try {
            valueBytes = value.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException ioex) {
            throw new CommandException("Unable to encode value '" + value + "' to a byte array in FIXBuilder.\n" + ioex.toString());
        }
        int sizeNeeded = tagBytes.length + valueBytes.length + 2;
        this.checkCapacity(sizeNeeded);
        int writeIndex = this.size;
        System.arraycopy(tagBytes, 0, this.buffer, writeIndex, tagBytes.length);
        this.buffer[writeIndex += tagBytes.length] = 61;
        System.arraycopy(valueBytes, 0, this.buffer, ++writeIndex, valueBytes.length);
        this.buffer[writeIndex += valueBytes.length] = this.fieldSeparator;
        this.size += sizeNeeded;
        return this;
    }
}

