/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.BookmarkRingBuffer;
import com.crankuptheamps.client.BookmarkStore;
import com.crankuptheamps.client.BookmarkStoreResizeHandler;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.Pool;
import com.crankuptheamps.client.exception.AMPSException;
import com.crankuptheamps.client.fields.BookmarkField;
import com.crankuptheamps.client.fields.Field;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;

public class RingBookmarkStore
implements BookmarkStore {
    MappedByteBuffer _buffer;
    private static final int ENTRIES = 16384;
    private static final int ENTRY_SIZE = 128;
    private HashMap<Field, Subscription> _map;
    private int _free = 16384;
    RandomAccessFile _file;
    FileChannel _channel;
    String _path;
    BookmarkStoreResizeHandler _resizeHandler = null;
    private int _serverVersion = 4000000;
    Pool<Subscription> _pool;

    public RingBookmarkStore(String path) throws AMPSException {
        this(path, 1);
    }

    public RingBookmarkStore(String path, int targetNumberOfSubscriptions) throws AMPSException {
        try {
            this._path = path;
            this._file = new RandomAccessFile(this._path, "rw");
            this._pool = new Pool<Subscription>(Subscription.class, targetNumberOfSubscriptions);
        }
        catch (IOException ioex) {
            throw new AMPSException("I/O Error initializing file " + path, ioex);
        }
        this.init();
    }

    public long log(Message message) throws AMPSException {
        BookmarkField bookmark = message.getBookmarkRaw();
        Subscription sub = (Subscription)message.getSubscription();
        if (sub == null) {
            Field subId = message.getSubIdRaw();
            if (subId == null || subId.isNull()) {
                subId = message.getSubIdsRaw();
            }
            sub = this.find(subId);
            message.setSubscription(sub);
        }
        long seqNo = sub.log(bookmark);
        message.setBookmarkSeqNo(seqNo);
        return seqNo;
    }

    public void discard(Field subId, long bookmarkSeqNo) throws AMPSException {
        this.find(subId).discard(bookmarkSeqNo);
    }

    public void discard(Message message) throws AMPSException {
        long bookmark = message.getBookmarkSeqNo();
        Subscription sub = (Subscription)message.getSubscription();
        if (sub == null) {
            Field subId = message.getSubIdRaw();
            if (subId == null || subId.isNull()) {
                subId = message.getSubIdsRaw();
            }
            sub = this.find(subId);
            message.setSubscription(sub);
        }
        sub.discard(bookmark);
    }

    public Field getMostRecent(Field subId) throws AMPSException {
        return this.find(subId).getMostRecent();
    }

    public boolean isDiscarded(Message message) throws AMPSException {
        BookmarkField bookmark = message.getBookmarkRaw();
        Subscription sub = (Subscription)message.getSubscription();
        if (sub == null) {
            Field subId = message.getSubIdRaw();
            if (subId == null || subId.isNull()) {
                subId = message.getSubIdsRaw();
            }
            sub = this.find(subId);
            message.setSubscription(sub);
        }
        return sub.isDiscarded(bookmark);
    }

    private void recover() throws AMPSException {
        byte firstByte;
        int currentEntry;
        for (currentEntry = 0; currentEntry < 16384 && (firstByte = this._buffer.get(currentEntry * 128)) != 0; ++currentEntry) {
            int idLength;
            byte[] id = new byte[31];
            this._buffer.position(currentEntry * 128);
            this._buffer.get(id);
            for (idLength = 0; idLength < id.length && id[idLength] != 0; ++idLength) {
            }
            Field f = new Field(id, 0, idLength);
            Subscription subscription = this._pool.get();
            subscription.init(this._buffer, currentEntry * 128);
            try {
                this._map.put(f, subscription);
            }
            catch (Exception e) {
                throw new AMPSException("Bookmark store corrupted.", e);
            }
            subscription.recover();
        }
        if (currentEntry == 16384) {
            throw new AMPSException("Unable to allocate space in this bookmark store.");
        }
        this._free = currentEntry;
    }

    private synchronized Subscription find(Field subId) throws AMPSException {
        if (this._map.containsKey(subId)) {
            return this._map.get(subId);
        }
        if (this._free >= 16384) {
            throw new AMPSException("Unable to allocate space in this bookmark store.");
        }
        int pos = this._free++;
        Subscription subscription = this._pool.get();
        subscription.init(this._buffer, pos * 128);
        subscription.setResizeHandler(this._resizeHandler, this);
        this._map.put(subId.copy(), subscription);
        this._buffer.position(pos * 128);
        for (int i = 0; i < subId.length; ++i) {
            this._buffer.put(subId.buffer[subId.position + i]);
        }
        return subscription;
    }

    public void persisted(Field subId, BookmarkField bookmark) throws AMPSException {
    }

    public void persisted(Field subId, long bookmark) throws AMPSException {
    }

    public void noPersistedAcks(Field subId) throws AMPSException {
    }

    public long getOldestBookmarkSeq(Field subId) throws AMPSException {
        return this.find(subId).getOldestBookmarkSeq();
    }

    public void setResizeHandler(BookmarkStoreResizeHandler handler) {
        this._resizeHandler = handler;
        for (Map.Entry<Field, Subscription> pairs : this._map.entrySet()) {
            pairs.getValue().setResizeHandler(handler, this);
        }
    }

    public synchronized void purge() throws AMPSException {
        int longs = this._buffer.capacity() / 8;
        this._buffer.position(0);
        for (int i = 0; i < longs; ++i) {
            this._buffer.putLong(0L);
        }
        this._buffer.position(0);
        this._buffer.force();
        this._map = new HashMap();
        this._free = 0;
        this.recover();
    }

    private void init() throws AMPSException {
        try {
            this._channel = this._file.getChannel();
            this._buffer = this._channel.map(FileChannel.MapMode.READ_WRITE, 0L, 0x200000L);
            this._channel.close();
            this._file.close();
        }
        catch (IOException ioex) {
            throw new AMPSException("error opening store.", ioex);
        }
        this._map = new HashMap();
        this._free = 0;
        this.recover();
    }

    public void setServerVersion(int version) {
        this._serverVersion = version;
    }

    static class Subscription
    implements com.crankuptheamps.client.Subscription {
        ByteBuffer _buffer;
        int _offset;
        short _currentDiskPosition = 0;
        BookmarkRingBuffer _ring = new BookmarkRingBuffer();
        static final int BYTES_BOOKMARK = 32;
        static final int BYTES_SUBID = 32;
        static final short POSITIONS = 3;

        public void init(ByteBuffer buffer, int offset) throws AMPSException {
            this._ring.noPersistedAcks();
            this._buffer = buffer;
            this._offset = offset;
            this.recover();
        }

        public synchronized long log(BookmarkField bookmark) {
            return this._ring.log(bookmark);
        }

        public boolean isDiscarded(BookmarkField bookmark) {
            return false;
        }

        public synchronized void discard(long bookmark) {
            if (this._ring.discard(bookmark)) {
                this.write(this._ring.getLastDiscarded());
            }
        }

        public synchronized Field getMostRecent() {
            return this._ring.getLastDiscarded();
        }

        public synchronized Field getMostRecentList() {
            return this._ring.getLastDiscarded();
        }

        public boolean isDiscarded(Field bookmark) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void write(Field bookmark) {
            Subscription subscription = this;
            synchronized (subscription) {
                int i;
                short nextDiskPosition = (short)((this._currentDiskPosition + 1) % 3);
                this._buffer.put(this._offset + 32 + 32 * nextDiskPosition, (byte)42);
                this._buffer.position(this._offset + 32 + 32 * this._currentDiskPosition + 1);
                for (i = 0; i < bookmark.length; ++i) {
                    this._buffer.put(bookmark.byteAt(i));
                }
                for (i = 0; i < 32 - (bookmark.length + 2); ++i) {
                    this._buffer.put((byte)0);
                }
                this._buffer.put(this._offset + 32 + 32 * this._currentDiskPosition, (byte)43);
                this._currentDiskPosition = nextDiskPosition;
            }
        }

        private void recover() {
            byte b;
            int foundCursor;
            for (foundCursor = 0; foundCursor < 3 && (b = this._buffer.get(this._offset + 32 + 32 * foundCursor)) != 42; foundCursor = (int)((short)(foundCursor + 1))) {
            }
            if (foundCursor == 0 && (b = this._buffer.get(this._offset + 32 + 64)) == 42) {
                foundCursor = 2;
            }
            if (foundCursor < 3) {
                int bookmarkLength;
                this._currentDiskPosition = (short)foundCursor;
                int mostRecentValid = this._currentDiskPosition == 0 ? 2 : this._currentDiskPosition - 1;
                byte[] buf = new byte[31];
                this._buffer.position(this._offset + 32 + 32 * mostRecentValid + 1);
                this._buffer.get(buf);
                for (bookmarkLength = 0; bookmarkLength < buf.length && buf[bookmarkLength] != 0; ++bookmarkLength) {
                }
                try {
                    BookmarkField f = new BookmarkField();
                    f.set(buf, 0, bookmarkLength);
                    this._ring.discard(this._ring.log(f));
                }
                catch (Exception e) {}
            } else {
                this._currentDiskPosition = 0;
            }
        }

        public synchronized void persisted(BookmarkField bookmark) {
        }

        public synchronized void persisted(long bookmark) {
        }

        public void setLastPersisted(long bookmark) {
        }

        public void setLastPersisted(BookmarkField bookmark) {
        }

        public synchronized void noPersistedAcks() {
        }

        public synchronized void setPersistedAcks() {
        }

        public long getOldestBookmarkSeq() {
            return this._ring.getStartIndex();
        }

        public void setResizeHandler(BookmarkStoreResizeHandler handler, BookmarkStore store) {
            this._ring.setResizeHandler(handler, store);
        }
    }
}

