/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.DefaultTransportFilter;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.MessageHandler;
import com.crankuptheamps.client.Protocol;
import com.crankuptheamps.client.TCPTransportImpl;
import com.crankuptheamps.client.Transport;
import com.crankuptheamps.client.TransportDisconnectHandler;
import com.crankuptheamps.client.TransportFilter;
import com.crankuptheamps.client.exception.AlreadyConnectedException;
import com.crankuptheamps.client.exception.ConnectionRefusedException;
import com.crankuptheamps.client.exception.DisconnectedException;
import com.crankuptheamps.client.exception.InvalidURIException;
import com.crankuptheamps.client.exception.RetryOperationException;
import java.beans.ExceptionListener;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TCPTransport
implements Transport {
    protected TCPTransportImpl _impl = null;
    private Protocol _protocol = null;
    private final Lock _sendLock = new ReentrantLock();
    private ByteBuffer _sendBuffer = ByteBuffer.allocate(4096);
    private static boolean _useDaemonThreads = false;

    protected TCPTransportImpl constructTransportImpl(Protocol protocol, Properties properties) {
        return new TCPTransportImpl(protocol, properties, new DefaultTransportFilter());
    }

    public TCPTransport(Protocol protocol, Properties properties) {
        this._protocol = protocol;
        this._impl = this.constructTransportImpl(protocol, properties);
    }

    public TCPTransport(Protocol msgType) {
        this(msgType, null);
    }

    public static void setDaemon(boolean daemonThreads) {
        _useDaemonThreads = daemonThreads;
    }

    public static boolean isDaemon() {
        return _useDaemonThreads;
    }

    public static TCPTransport createTransport(Protocol messageType) {
        return new TCPTransport(messageType);
    }

    public void setMessageHandler(MessageHandler ml) {
        this._impl.setMessageHandler(ml);
    }

    public void setDisconnectHandler(TransportDisconnectHandler dh) {
        this._impl.setDisconnectHandler(dh);
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this._impl.setExceptionListener(exceptionListener);
    }

    public void setTransportFilter(TransportFilter filter) {
        this._impl.setTransportFilter(filter);
    }

    public void connect(URI uri) throws ConnectionRefusedException, AlreadyConnectedException, InvalidURIException {
        this._impl.connect(uri);
    }

    public void close() {
        this._impl.disconnect();
    }

    public void disconnect() {
        this._impl.disconnect();
    }

    public void handleCloseEvent(int failedVersion_, String message, Exception e) throws DisconnectedException, RetryOperationException {
        this._impl.handleCloseEvent(failedVersion_, message, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendWithoutRetry(Message message) throws DisconnectedException {
        this._sendLock.lock();
        try {
            this._sendBuffer.clear();
            this._sendBuffer.position(4);
            Message.SerializationResult sr = message.serialize(this._sendBuffer);
            if (sr == Message.SerializationResult.BufferTooSmall) {
                this._sendBuffer = ByteBuffer.allocate(2 * this._sendBuffer.capacity());
                this.sendWithoutRetry(message);
                return;
            }
            if (sr == Message.SerializationResult.OK) {
                this._sendBuffer.putInt(0, this._sendBuffer.position() - 4);
                this._sendBuffer.flip();
                this._impl.send(this._sendBuffer);
            }
        }
        finally {
            this._sendLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message) throws DisconnectedException {
        this._sendLock.lock();
        try {
            int currentVersion = this.getVersion();
            try {
                this.sendWithoutRetry(message);
            }
            catch (DisconnectedException ex) {
                try {
                    this.handleCloseEvent(currentVersion, "Exception occured while sending", ex);
                }
                catch (RetryOperationException r) {
                    // empty catch block
                }
                throw ex;
            }
        }
        finally {
            this._sendLock.unlock();
        }
    }

    public Message allocateMessage() {
        return this._protocol.allocateMessage();
    }

    public long writeQueueSize() throws DisconnectedException {
        try {
            return this._impl.writeQueueSize();
        }
        catch (NullPointerException e) {
            throw new DisconnectedException("not connected");
        }
    }

    public long readQueueSize() throws DisconnectedException {
        try {
            return this._impl.writeQueueSize();
        }
        catch (NullPointerException e) {
            throw new DisconnectedException("not connected");
        }
    }

    public long flush() throws DisconnectedException {
        try {
            return this._impl.flush();
        }
        catch (NullPointerException e) {
            throw new DisconnectedException("not connected");
        }
    }

    public long flush(long timeout) throws DisconnectedException {
        try {
            return this._impl.flush(timeout);
        }
        catch (NullPointerException e) {
            throw new DisconnectedException("not connected");
        }
    }

    public Socket socket() {
        try {
            return this._impl.socket();
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getVersion() {
        return this._impl._connectionVersion;
    }

    public void setReadTimeout(int readTimeout_) {
        this._impl.setReadTimeout(readTimeout_);
    }
}

