/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client.fields;

import com.crankuptheamps.client.fields.Field;
import java.io.UnsupportedEncodingException;

public class ReasonField
extends Field {
    protected static final String LATIN1 = "ISO-8859-1";
    private static String[] reasonStrings = new String[]{"", "duplicate", "bad filter", "bad regex topic", "subscription already exists", "deleted", "expired", "match", "invalid topic", "name in use", "auth failure", "not entitled", "authentication disabled", "invalid bookmark", "invalid orderby", "subid in use"};

    public int getValue() {
        if (this.buffer != null) {
            return ReasonField.decodeReason(this.buffer, this.position, this.length);
        }
        return 0;
    }

    public String getText() {
        if (this.buffer != null) {
            return new String(this.buffer, this.position, this.length);
        }
        return "";
    }

    private void set(String value) {
        try {
            this.set(value.getBytes(LATIN1));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void setValue(int v) {
        if (v == 0 || v > reasonStrings.length - 1) {
            this.reset();
            return;
        }
        this.set(reasonStrings[v]);
    }

    static final int decodeReason(byte[] buffer, int pos, int len) {
        String reasonBytes = new String(buffer, pos, len);
        for (int i = 0; i < reasonStrings.length; ++i) {
            if (!reasonStrings[i].equals(reasonBytes)) continue;
            return i;
        }
        return 16;
    }

    public static final String encodeReason(int r) {
        if (r > reasonStrings.length - 1) {
            return "unknown";
        }
        return reasonStrings[r];
    }
}

