/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client.fields;

import com.crankuptheamps.client.fields.Field;
import java.io.UnsupportedEncodingException;

public class StatusField
extends Field {
    protected static final String LATIN1 = "ISO-8859-1";
    protected static final byte LATIN1_ZERO = 48;
    private static byte[] ST_SUCCESS = null;
    private static byte[] ST_FAILURE = null;
    private static byte[] ST_RETRY = null;

    public int getValue() {
        if (this.buffer != null) {
            return StatusField.decodeStatus(this.buffer, this.position, this.length);
        }
        return 0;
    }

    public void setValue(int v) {
        if (v == 0) {
            this.reset();
            return;
        }
        switch (v) {
            case 1: {
                this.set(ST_SUCCESS);
                break;
            }
            case 2: {
                this.set(ST_FAILURE);
                break;
            }
            case 3: {
                this.set(ST_RETRY);
                break;
            }
            default: {
                this.reset();
            }
        }
    }

    static final int decodeStatus(byte[] buffer, int pos, int len) {
        if (len == 7) {
            if (buffer[pos] == 115) {
                return 1;
            }
            return 2;
        }
        if (len == 5) {
            return 3;
        }
        return 0;
    }

    public static final String encodeStatus(int s) {
        switch (s) {
            case 1: {
                return "success";
            }
            case 2: {
                return "failure";
            }
            case 3: {
                return "retry";
            }
            case 0: {
                return "none";
            }
        }
        return "none";
    }

    static {
        try {
            ST_SUCCESS = "success".getBytes(LATIN1);
            ST_FAILURE = "failure".getBytes(LATIN1);
            ST_RETRY = "retry".getBytes(LATIN1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

