/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.spark;

import com.crankuptheamps.client.Client;
import com.crankuptheamps.client.ClientDisconnectHandler;
import com.crankuptheamps.client.exception.AMPSException;
import com.crankuptheamps.client.exception.ConnectionException;
import com.crankuptheamps.spark.CommandOption;
import com.crankuptheamps.spark.SparkCommand;
import java.util.UUID;

public class PingCommand
extends SparkCommand {
    private String uriString = null;

    public PingCommand(String name) {
        super(name);
        this.addOption(new CommandOption("verbose", "prints time to connect and logon to stderr", false));
        StringBuilder example = new StringBuilder(1024);
        example.append("  % ./spark ping -server localhost:9003 -proto amps\n\n");
        example.append("    Connects to the AMPS instance listening on port 9003 using the amps protocol and attempts to logon.\n");
        this.addExample(example.toString());
    }

    void execute(String[] argv) {
        this.parseArgs(argv, 1);
        String[] userAndServer = ((CommandOption)this.options.get("server")).getValue().split("@", 2);
        String server = userAndServer.length == 2 ? userAndServer[1] : userAndServer[0];
        String type = ((CommandOption)this.options.get("proto")).getValue();
        if (!(type.equals("xml") || type.equals("fix") || type.equals("nvfix") || type.equals("amps") || type.equals("json"))) {
            this.badUsage("prot argument needs to be 'fix', 'xml', 'nvfix', 'amps', or 'json'.");
        }
        String userId = userAndServer.length == 2 ? userAndServer[0] : System.getProperty("user.name");
        String clientName = "spark-subscribe-" + userId + "-" + UUID.randomUUID().toString();
        Client client = new Client(clientName, 131072);
        client.setDisconnectHandler(new SparkDisconnectHandler());
        long start = System.currentTimeMillis();
        try {
            this.uriString = "tcp://" + userId + "@" + server + "/" + type;
            client.connect(this.uriString);
            long connectTime = System.currentTimeMillis() - start;
            client.logon(5000L, this.createAuthenticator(this.uriString));
            long logonTime = System.currentTimeMillis() - start - connectTime;
            System.out.println("Successfully connected to " + this.uriString);
            if (((CommandOption)this.options.get("verbose")).hasValue()) {
                System.err.format("Total time: %d ms (connection took %d ms, logon took %d ms.)\n", connectTime + logonTime, connectTime, logonTime);
            }
        }
        catch (ConnectionException e) {
            System.err.println("Unable to connect to AMPS (" + e.toString().trim() + ").");
            System.exit(1);
        }
        client.close();
    }

    private class SparkDisconnectHandler
    implements ClientDisconnectHandler {
        private SparkDisconnectHandler() {
        }

        public void invoke(Client client) {
            System.err.format("DISCONNECTED, trying to reconnect...%n", new Object[0]);
            try {
                client.connect(PingCommand.this.uriString);
                client.logon(5000L, PingCommand.this.createAuthenticator(PingCommand.this.uriString));
            }
            catch (AMPSException e) {
                System.err.println("Unable to re-connect to AMPS (" + e + ").");
                System.exit(1);
            }
        }
    }
}

