/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.spark;

import com.crankuptheamps.client.Client;
import com.crankuptheamps.client.Command;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.exception.AMPSException;
import com.crankuptheamps.client.exception.ConnectionException;
import com.crankuptheamps.spark.CommandOption;
import com.crankuptheamps.spark.SparkCommand;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import java.util.UUID;

public class SOWDeleteCommand
extends SparkCommand {
    String uriString = null;
    String topic = null;
    String filter = null;
    private static final String LATIN1 = "ISO-8859-1";

    public SOWDeleteCommand(String name) {
        super(name);
        this.addOption(new CommandOption("topic", "topic to delete from", true));
        this.addOption(new CommandOption("filter", "content filter to use", false));
        this.addOption(new CommandOption("delimiter", "decimal value of message separator character (default 10)", false));
        this.addOption(new CommandOption("timeout", "timeout to wait for command to return in milliseconds", false));
        this.addOption(new CommandOption("file", "file to create delete records from, uses standard in when omitted and no filter is specified", false));
        StringBuilder example = new StringBuilder(1024);
        example.append("  % ./spark sow_delete -server localhost:9003 -topic Trades -filter \"/55 = 'Transport.123'\"\n");
        example.append("    Connects to the AMPS instance listening on port 9003\n");
        example.append("    and deletes messages in topic 'Trades' that have\n");
        example.append("    tag 55 set to 'Transport.123'\n\n");
        example.append("  % ./spark sow_delete -server localhost:9003 -topic Trades -file deletes.fix\n");
        example.append("    Connects to the AMPS instance listening on port 9003\n");
        example.append("    and deletes messages in topic 'Trades' that match\n");
        example.append("    the messages found in the `deletes.fix' file.\n\n");
        example.append("  % ./spark sow_delete -server localhost:9003 -topic Trades\n");
        example.append("    Connects to the AMPS instance listening on port 9003\n");
        example.append("    and deletes messages in topic 'Trades' that match\n");
        example.append("    the messages read from standard input.\n");
        this.addExample(example.toString());
    }

    public void deleteByFilter(Client client, String topic, String filter, int timeout) throws AMPSException {
        long start = System.currentTimeMillis();
        Message m = client.execute(new Command("sow_delete").setTopic(topic).setFilter(filter).setTimeout(timeout).addAckType(32)).next();
        System.err.println("Deleted " + m.getMatches() + " records in " + (System.currentTimeMillis() - start) + " ms.");
    }

    public void deleteByData(Client client, String topic, String fileName, String delimiter, int timeout) throws AMPSException {
        Scanner scanner;
        long start = 0L;
        String line = "";
        if (fileName != null) {
            try {
                scanner = new Scanner(new File(fileName), LATIN1);
            }
            catch (FileNotFoundException e) {
                this.badUsage("file '" + fileName + "' not found");
                return;
            }
        } else {
            scanner = new Scanner(System.in);
        }
        start = System.currentTimeMillis();
        Command command = new Command(32).setTopic(topic).addAckType(32).setTimeout(timeout);
        if (delimiter != null) {
            try {
                String strDelim = Character.toString((char)Integer.parseInt(delimiter));
                scanner.useDelimiter(strDelim);
            }
            catch (NumberFormatException nfex) {
                System.err.println("Delimiter is not a valid integer");
                System.exit(1);
            }
        } else {
            scanner.useDelimiter(System.getProperty("line.separator"));
        }
        long sent = 0L;
        long deleted = 0L;
        while (scanner.hasNext()) {
            line = scanner.next();
            command.setData(line);
            Message stats = client.execute(command).next();
            ++sent;
            deleted += stats.getRecordsDeleted();
        }
        System.err.format("Sent %d delete messages and deleted %d records in %d ms.\n", sent, deleted, System.currentTimeMillis() - start);
        scanner.close();
    }

    void execute(String[] argv) {
        this.parseArgs(argv, 1);
        String[] userAndServer = ((CommandOption)this.options.get("server")).getValue().split("@", 2);
        String server = userAndServer.length == 2 ? userAndServer[1] : userAndServer[0];
        this.topic = ((CommandOption)this.options.get("topic")).getValue();
        String type = ((CommandOption)this.options.get("proto")).getValue();
        String delimiter = ((CommandOption)this.options.get("delimiter")).getValue();
        String fileName = null;
        int timeout = 5000;
        if (!(type.equals("xml") || type.equals("fix") || type.equals("nvfix") || type.equals("amps") || type.equals("json"))) {
            this.badUsage("prot argument needs to be 'fix', 'xml', 'nvfix', 'amps', or 'json'.");
        }
        if (((CommandOption)this.options.get("file")).hasValue()) {
            fileName = ((CommandOption)this.options.get("file")).getValue();
        }
        if (((CommandOption)this.options.get("filter")).hasValue()) {
            this.filter = ((CommandOption)this.options.get("filter")).getValue();
        }
        if (this.filter != null && fileName != null) {
            System.err.println("A filter and a filename cannot both be specified.");
            System.err.println("Specify a filter to delete a set of SOW records via a server-side query.");
            System.err.println("Specify a file name to delete a set of SOW records whose keys match those in the input file.");
            System.exit(1);
        }
        if (((CommandOption)this.options.get("timeout")).hasValue()) {
            timeout = Integer.parseInt(((CommandOption)this.options.get("timeout")).getValue());
        }
        String userId = userAndServer.length == 2 ? userAndServer[0] : System.getProperty("user.name");
        String clientName = "spark-sow-delete-" + userId + "-" + UUID.randomUUID().toString();
        Client client = new Client(clientName, 131072);
        try {
            this.uriString = "tcp://" + userId + "@" + server + "/" + type;
            client.connect(this.uriString);
            client.logon(5000L, this.createAuthenticator(this.uriString));
        }
        catch (ConnectionException e) {
            System.err.println("Unable to connect to AMPS (" + e + ").");
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Unable to connect to AMPS (" + e + ").");
            System.exit(1);
        }
        try {
            if (this.filter == null) {
                this.deleteByData(client, this.topic, fileName, delimiter, timeout);
            } else {
                this.deleteByFilter(client, this.topic, this.filter, timeout);
            }
            client.close();
        }
        catch (AMPSException e) {
            System.err.format("Error: " + e.toString(), new Object[0]);
            System.exit(1);
        }
    }
}

