/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.spark;

import com.crankuptheamps.client.Authenticator;
import com.crankuptheamps.client.exception.AuthenticationException;
import com.crankuptheamps.spark.AuthenticatorFactory;
import com.crankuptheamps.spark.CommandOption;
import java.lang.reflect.Constructor;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class SparkCommand {
    protected String name;
    protected TreeMap<String, CommandOption> options = new TreeMap();
    protected TreeSet<String> required = new TreeSet();
    protected TreeSet<String> optional = new TreeSet();
    protected LinkedList<String> examples = new LinkedList();
    protected LinkedList<String> extras = new LinkedList();
    protected String usage = null;
    protected TreeMap<String, String> synonyms = new TreeMap();

    public SparkCommand(String name) {
        this.name = name;
        this.addOption(new CommandOption("server", "AMPS server to connect to", true));
        this.addOption(new CommandOption("proto", "protocol to use (amps, fix, nvfix, xml)\n\t\t   (type, prot are synonyms for backward compatibility)", "amps"));
        this.addOption(new CommandOption("authenticator", "Custom AMPS authenticator factory to use", false));
        this.addSynonym("type", "proto");
        this.addSynonym("prot", "proto");
    }

    abstract void execute(String[] var1);

    public String getName() {
        return this.name;
    }

    public void addOption(CommandOption command) {
        this.options.put(command.getName(), command);
        if (command.isRequired()) {
            this.required.add(command.getName());
        } else {
            this.optional.add(command.getName());
        }
    }

    public void addSynonym(String synonym, String baseName) {
        this.synonyms.put(synonym, baseName);
    }

    public void addExample(String example) {
        this.examples.add(example);
    }

    public void addExtra(String extra) {
        this.extras.add(extra);
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    protected void badUsage(String message) {
        this.help();
        System.err.println(message);
        System.exit(1);
    }

    void parseArgs(String[] argv, int start) {
        String currentOption = null;
        for (int i = start; i < argv.length; ++i) {
            String current = argv[i];
            if (current.length() > 0 && current.charAt(0) == '-') {
                if (currentOption != null && !this.options.get(currentOption).hasValue()) {
                    this.options.get(currentOption).setValue("true");
                }
                if (this.options.containsKey(currentOption = current.substring(current.lastIndexOf(45) + 1))) continue;
                if (this.synonyms.containsKey(currentOption)) {
                    currentOption = this.synonyms.get(currentOption);
                    continue;
                }
                this.badUsage("Invalid argument specified: '" + current + "'");
                continue;
            }
            if (currentOption == null) {
                this.badUsage("Invalid argument specified: '" + current + "'");
            }
            this.options.get(currentOption).setValue(current);
        }
        if (currentOption != null && !this.options.get(currentOption).hasValue()) {
            this.options.get(currentOption).setValue("true");
        }
        for (CommandOption option : this.options.values()) {
            if (!option.isRequired() || option.hasValue()) continue;
            this.badUsage("The '" + option.getName() + "' option is required for the '" + this.getName() + "' command.");
        }
    }

    protected void dumpArgs() {
        for (CommandOption option : this.options.values()) {
            System.out.print(option.getName() + " = ");
            if (option.hasValue()) {
                System.out.println(option.getValue());
                continue;
            }
            System.out.println("<unset>");
        }
    }

    protected Authenticator createAuthenticator(String uri) throws AuthenticationException {
        CommandOption authenticatorOption = this.options.get("authenticator");
        String authFactoryName = "com.crankuptheamps.spark.DefaultAuthenticatorFactory";
        if (authenticatorOption.hasValue()) {
            authFactoryName = authenticatorOption.getValue();
        }
        AuthenticatorFactory af = null;
        try {
            Class<?> c = Class.forName(authFactoryName);
            Constructor<?> ctor = c.getConstructor(new Class[0]);
            af = (AuthenticatorFactory)ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new AuthenticationException("Could not find or create Authenticator Factory " + authFactoryName + ": " + e.toString(), e);
        }
        assert (af != null);
        return af.createAuthenticator(uri);
    }

    private String fillString(String v, int s, char c) {
        StringBuffer buffer = new StringBuffer(s);
        buffer.append(v);
        while (buffer.length() < s) {
            buffer.append(c);
        }
        return buffer.toString();
    }

    public void help() {
        System.out.println("===============================");
        System.out.println("- Spark - AMPS client utility -");
        System.out.println("===============================");
        System.out.println("Usage:");
        System.out.println("");
        if (this.usage == null) {
            System.out.println("  spark " + this.getName() + " [options]");
        } else {
            System.out.println("  " + this.usage);
        }
        System.out.println("");
        if (this.required.size() > 0) {
            System.out.println("Required Parameters:");
            System.out.println("");
            for (String r : this.required) {
                System.out.println("  " + this.fillString(r, 10, ' ') + "-- " + this.options.get(r).getDescription());
            }
            System.out.println("");
        }
        if (this.optional.size() > 0) {
            System.out.println("Options:");
            System.out.println("");
            for (String r : this.optional) {
                System.out.print("  " + this.fillString(r, 14, ' ') + "-- " + this.options.get(r).getDescription());
                if (this.options.get(r).getDefaultValue() != null) {
                    System.out.println(" (default: " + this.options.get(r).getDefaultValue() + ")");
                    continue;
                }
                System.out.println();
            }
            System.out.println("");
        }
        for (String extra : this.extras) {
            System.out.println(extra);
        }
        if (this.examples.size() > 0) {
            if (this.examples.size() == 1) {
                System.out.println("Example:");
            } else {
                System.out.println("Examples:");
            }
            System.out.println("");
            for (String example : this.examples) {
                System.out.println(example);
            }
            System.out.println("");
        }
    }
}

