package com.crankuptheamps.examples;

import java.lang.Thread;

import com.crankuptheamps.client.*;
import com.crankuptheamps.client.exception.*;

/** Stateless bookmark subscriber
*
* This sample retrieves messages from a state-of-the-world database. The program flow is simple:
*
* * Connect to AMPS
* * Logon
* * Request replay from "messages-history" topic from the last message
*   received.
*
* This sample doesn't include error handling or connection
* retry logic.
*
* (c) 2013 60East Technologies, Inc.  All rights reserved.
* This file is a part of the AMPS Evaluation Kit.
*/

public class StatelessBookmarkSubscriber  {

  // The location of the AMPS server.
  private static final String uri_ = "tcp://127.0.0.1:9007/json";

  /**
   * main method.
   *
   * @param args -- No command line options read.
   */

  public static void main(String[] args) {

    HAClient client = new HAClient("exampleSubscriberWithReplay");
    Client controlchannel = new Client(client.getName() + "_bookmark_manager");
    AMPSBookmarkStore bookmarkStore = null;
    try {

      controlchannel.connect(uri_);
      controlchannel.logon();

      bookmarkStore = new AMPSBookmarkStore(controlchannel, client.getName());
      bookmarkStore.setPersistEvery(3);
      client.setBookmarkStore(bookmarkStore);


      DefaultServerChooser sc = new DefaultServerChooser();
      sc.add(uri_);
      client.setServerChooser(sc);

      client.connectAndLogon();

      // create the object to process the messages.

      BookmarkMessageHandler handler = new BookmarkMessageHandler(client);
      handler.setMaximum(10);

      // Enter the subscription. This statement requests all
      // messages that have not been previously processed on the
      // "messages-history" topic.
   
      client.executeAsync( new Command("subscribe")
                             .setTopic("messages-history")
                             .setCommandId(new CommandId("sample-replay-id"))
                             .setSubId(new CommandId("sample-replay-id"))
                             .setBookmark(Client.Bookmarks.MOST_RECENT)
                          , handler);


       handler.waitUntilDone();


    }
    catch (AMPSException e) {
      System.err.println(e.getLocalizedMessage());
      e.printStackTrace(System.err);
    }
    finally {
      client.disconnect();
      if (bookmarkStore != null) bookmarkStore.close();
      controlchannel.close();
    }
    System.exit(0);
  }

}
