////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////

package com.crankuptheamps.client;

import com.crankuptheamps.client.exception.AuthenticationException;

public interface Authenticator
{
    /** Called by AMPS.Client, just before the logon command is sent.
     * @param username_ The current value of the username as specified in the URI.
     * @param currentPassword_ The current value of the password, as specified in the URI.
     * @return The value that should be placed into the Password header field of the logon command.
     * @throws AuthenticationException An error occured while authenticating.
     */
    public String authenticate(String username_, String currentPassword_) throws AuthenticationException;

    /** Called when a logon "ack" is received with a status of "retry".
     *  AMPS will continue trying to logon as long as the server returns "retry",
     *  and this method continues to succeed.
     *  @param username_ The username returned by the server's ACK message.
     *  @param password_ The password or token returned in the server's ACK message.
     *  @return The value that should be placed into the Password header for the next logon attempt.
     *  @throws AuthenticationException An error occured while authenticating.
     */
    public String retry(String username_, String password_) throws AuthenticationException;

    /** Called when a logon completes successfully.
     *  Once a logon has completed, this method is called with the username and password
     *  that caused a successful logon
     *  @param username_ The username that successfully logged on to the server.
     *  @param password_ The password that successfully logged on to the server.
     *  @param reason_ The reason (a value from Message.Reason) for the successful completion.
     *  @throws AuthenticationException The client-side authentication module detected an error.
     */
    public void completed(String username_, String password_, int reason_) throws AuthenticationException;
}

