////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////
package com.crankuptheamps.client;

import java.util.HashMap;

/**
 * 
 * A Key, Value mapping for metadata about the state of an AMPS connection.
 * 
 * Valid keys include:
 * <pre>
 *      client.uri                      The URI this client is connected to, NULL if no connection has been attempted.
 *      client.name                     The name of this client.
 *      client.username                 The most recently-used username for this client.  NULL if no username is supplied.
 *      publishStore.unpersistedCount   The count of unpersisted messages in the local store.  NULL if no PublishStore has been set on the client.
 *      haClient.reconnectDelay         The delay between reconnect attempts.  NULL for non-HA clients.
 *      haClient.timeout                The default timeout used when re-logging on.  NULL for non-HA clients.
 * </pre>
 */
public class ConnectionInfo extends HashMap<String, Object>
{
    public static final long serialVersionUID = 1;

    
}
