////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////

package com.crankuptheamps.client;

import java.util.HashMap;
import java.util.Map;

public final class FIXShredder
{
    final private byte fieldSeparator;

    public FIXShredder(byte fieldSeparator)
    {
        this.fieldSeparator = fieldSeparator;
    }

    public Map<Integer, CharSequence> toMap(final String fix)
    throws IndexOutOfBoundsException
    {
        int index = 0;
        final int length = fix.length();
        final Map<Integer, CharSequence> map = new HashMap<Integer,CharSequence>(128);
        while(index < length - 1)
        {
            // First, read the tag
            final int endTag = fix.indexOf('=',index);
            if(endTag == -1) break;
            final int endValue = fix.indexOf(this.fieldSeparator,endTag+1);
            if(endValue == -1) break;
            map.put(new Integer(fix.subSequence(index,endTag).toString()),
                    fix.subSequence(endTag+1,endValue));
            index = endValue + 1;
        }
        return map;
    }
}

