////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////
package com.crankuptheamps.client;

/**
 * An interface for receiving information on messages that you've written, but
 * for which the server indicates were not persisted.
 */
public interface FailedWriteHandler
{
    /**
     * The AMPS instance reports that a write has failed.
     * @param sequenceNumber The sequence number of the message that could not be written.
     * @param operation A value from Message.Command (Publish, DeltaPublish, or SOWDelete).
     * @param topic The topic of the message.
     * @param topicOffset The index in topic where the topic bytes begin.
     * @param topicLength The length of the topic, in bytes.
     * @param data The data of the message.
     * @param dataOffset The index in data where the data bytes begin.
     * @param dataLength The length of the data, in bytes.
     * @param correlationId the correlation ID for this message
     * @param correlationIdOffset the offset into the correlation ID array where the correlation ID begins
     * @param correlationIdLength the length of the correlation ID
     * @param reason A value from Message.Reason indicating the reason for this failed write.
    */
    public void failedWrite(long sequenceNumber, int operation, 
            byte[] topic,         long topicOffset,         long topicLength,
            byte[] data,          long dataOffset,          long dataLength,
            byte[] correlationId, long correlationIdOffset, long correlationIdLength,
            int reason);
}
