////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////
package com.crankuptheamps.client;

import com.crankuptheamps.client.fields.*;

import java.io.UnsupportedEncodingException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.HashSet;
import java.util.Set;

public class JSONMessage extends Message {

    private static final String LATIN1 = "ISO-8859-1";

    private static byte[] TG_COMMAND = null;
    private static byte[] TG_COMMANDID = null;
    private static byte[] TG_CORRELATION_ID = null;
    private static byte[] TG_CLIENTNAME = null;
    private static byte[] TG_USERID = null;
    private static byte[] TG_TIMESTAMP = null;
    private static byte[] TG_TOPIC = null;
    private static byte[] TG_FILTER = null;
    private static byte[] TG_ORDERBY = null;
    private static byte[] TG_ACKTYPE = null;
    private static byte[] TG_SUBID = null;
    private static byte[] TG_VERSION = null;
    private static byte[] TG_EXPIRATION = null;
    private static byte[] TG_SENDMATCHINGIDS = null;
    private static byte[] TG_STATUS = null;
    private static byte[] TG_QUERYID = null;
    private static byte[] TG_SENDOOF = null;
    private static byte[] TG_BATCHSIZE = null;
    private static byte[] TG_TOPN = null;
    private static byte[] TG_SENDEMPTIES = null;
    private static byte[] TG_MAXMESSAGES = null;
    private static byte[] TG_SOWKEYS = null;
    private static byte[] TG_SEQUENCE = null;
    private static byte[] TG_BOOKMARK = null;
    private static byte[] TG_PASSWORD = null;

    private static byte[] TG_RECORDS_INSERTED = null;
    private static byte[] TG_RECORDS_UPDATED = null;
    private static byte[] TG_RECORDS_DELETED = null;
    private static byte[] TG_RECORDS_RETURNED = null;
    private static byte[] TG_TOPIC_MATCHES = null;
    private static byte[] TG_MATCHES = null;
    private static byte[] TG_LENGTH = null;
    private static byte[] TG_SOW_KEY = null;
    private static byte[] TG_GROUP_SEQ_NO = null;
    private static byte[] TG_SUB_IDS = null;
    private static byte[] TG_REASON = null;
    private static byte[] TG_OPTIONS = null;

    private static byte[] COMMA = null;
    private static byte[] QUOTE = null;
    private static byte[] QUOTE_COLON = null;
    private static byte[] OPEN_BRACE = null;
    private static byte[] CLOSE_BRACE = null;

    static
    {
        try
        {
            TG_COMMAND = "c".getBytes(LATIN1);
            TG_COMMANDID = "cid".getBytes(LATIN1);
            TG_CORRELATION_ID = "x".getBytes(LATIN1);
            TG_CLIENTNAME = "client_name".getBytes(LATIN1);
            TG_USERID = "user_id".getBytes(LATIN1);
            TG_TIMESTAMP = "ts".getBytes(LATIN1);
            TG_TOPIC = "t".getBytes(LATIN1);
            TG_FILTER = "filter".getBytes(LATIN1);
            TG_ORDERBY = "orderby".getBytes(LATIN1);
            TG_ACKTYPE = "a".getBytes(LATIN1);
            TG_SUBID = "sub_id".getBytes(LATIN1);
            TG_VERSION = "v".getBytes(LATIN1);
            TG_EXPIRATION = "e".getBytes(LATIN1);
            TG_SENDMATCHINGIDS = "send_matching_ids".getBytes(LATIN1);
            TG_STATUS = "status".getBytes(LATIN1);
            TG_QUERYID = "query_id".getBytes(LATIN1);
            TG_SENDOOF = "send_oof".getBytes(LATIN1);
            TG_BATCHSIZE = "batch_size".getBytes(LATIN1);
            TG_TOPN = "top_n".getBytes(LATIN1);
            TG_SENDEMPTIES = "send_empty".getBytes(LATIN1);
            TG_MAXMESSAGES = "max_msgs".getBytes(LATIN1);
            TG_SOWKEYS = "sow_keys".getBytes(LATIN1);
            TG_SEQUENCE = "s".getBytes(LATIN1);
            TG_BOOKMARK = "bookmark".getBytes(LATIN1);
            TG_PASSWORD = "pw".getBytes(LATIN1);
            TG_RECORDS_INSERTED = "records_inserted".getBytes(LATIN1);
            TG_RECORDS_UPDATED = "records_updated".getBytes(LATIN1);
            TG_RECORDS_DELETED = "records_deleted".getBytes(LATIN1);
            TG_RECORDS_RETURNED = "records_returned".getBytes(LATIN1);
            TG_TOPIC_MATCHES = "topic_matches".getBytes(LATIN1);
            TG_MATCHES = "matches".getBytes(LATIN1);
            TG_LENGTH = "l".getBytes(LATIN1);
            TG_SOW_KEY = "k".getBytes(LATIN1);
            TG_GROUP_SEQ_NO = "group_seq_num".getBytes(LATIN1);
            TG_SUB_IDS = "sub_ids".getBytes(LATIN1);
            TG_REASON = "reason".getBytes(LATIN1);
            TG_OPTIONS = "opts".getBytes(LATIN1);

            COMMA = ",".getBytes(LATIN1);
            QUOTE = "\"".getBytes(LATIN1);
            QUOTE_COLON = "\":".getBytes(LATIN1);
            OPEN_BRACE = "{".getBytes(LATIN1);
            CLOSE_BRACE = "}".getBytes(LATIN1);
        }
        catch (UnsupportedEncodingException e)
        {
        }
    }

    public JSONMessage(CharsetEncoder encoder,
            CharsetDecoder decoder)
    {
        super(encoder, decoder);
    }


    private static final Set<Class> QUOTED_CLASSES = new HashSet<Class>();

    static
    {
        QUOTED_CLASSES.add(StringField.class);
        QUOTED_CLASSES.add(CommandField.class);
        QUOTED_CLASSES.add(AckTypeField.class);
        QUOTED_CLASSES.add(BookmarkField.class);
        QUOTED_CLASSES.add(StatusField.class);
    }

    final private boolean needsEscape(byte[] fieldName)
    {
        switch((char)fieldName[0])
        {
        case 's':
        {
            switch(fieldName.length)
            {
            case 6:                //sub_id
            case 7:                //sub_ids
                return true;
            default:
                return false;
            }
        }
        case 'c':                 //client
        case 'f':                 //filter
        case 't':                 //topic
        case 'u':                 //user_id
        case 'p':                 //pw
            return true;
        default:
            return false;
        }
    }

    final private void escapeField(ByteBuffer b, Field field)
    {
        for(int i =0; i<field.length; ++i)
        {
            if(field.byteAt(i) == '\"' || field.byteAt(i) == '\\')
            {
                b.put((byte)'\\');
                b.put(field.byteAt(i));
            }
            else
            {
                b.put(field.byteAt(i));
            }
        }
    }

    final private int serializeMessageProperty(ByteBuffer b, byte[] tag, Field field, int count)
    {
        //
        // ,"field":"value"
        // "field":100
        // etc
        //
        if (field.buffer == null) return 0;

        if (count > 0) b.put(COMMA);
        b.put(QUOTE);
        b.put(tag);
        b.put(QUOTE_COLON);
        final boolean quoted = QUOTED_CLASSES.contains(field.getClass());
        if (quoted) b.put(QUOTE);

        if(needsEscape(tag))
            escapeField(b, field);
        else
            b.put(field.buffer, field.position, field.length);
        if (quoted) b.put(QUOTE);
        return 1;
    }

    SerializationResult serialize(ByteBuffer b)
    {
        try
        {
            b.put(OPEN_BRACE);
            int count = 0;
            count += serializeMessageProperty(b, TG_COMMAND, _Command, count);
            count += serializeMessageProperty(b, TG_COMMANDID, _CommandId, count);
            count += serializeMessageProperty(b, TG_CORRELATION_ID, _CorrelationId, count);
            count += serializeMessageProperty(b, TG_CLIENTNAME, _ClientName, count);
            count += serializeMessageProperty(b, TG_USERID, _UserId, count);
            count += serializeMessageProperty(b, TG_PASSWORD, _Password, count);
            count += serializeMessageProperty(b, TG_TIMESTAMP, _Timestamp, count);
            count += serializeMessageProperty(b, TG_TOPIC, _Topic, count);
            count += serializeMessageProperty(b, TG_FILTER, _Filter, count);
            count += serializeMessageProperty(b, TG_ORDERBY, _OrderBy, count);
            count += serializeMessageProperty(b, TG_ACKTYPE, _AckType, count);
            count += serializeMessageProperty(b, TG_OPTIONS, _Options, count);
            count += serializeMessageProperty(b, TG_SUBID, _SubId, count);
            count += serializeMessageProperty(b, TG_VERSION, _Version, count);
            count += serializeMessageProperty(b, TG_EXPIRATION, _Expiration, count);
            count += serializeMessageProperty(b, TG_SENDMATCHINGIDS, _SendMatchingIds, count);
            count += serializeMessageProperty(b, TG_STATUS, _Status, count);
            count += serializeMessageProperty(b, TG_QUERYID, _QueryId, count);
            count += serializeMessageProperty(b, TG_SENDOOF, _SendOOF, count);
            count += serializeMessageProperty(b, TG_BATCHSIZE, _BatchSize, count);
            count += serializeMessageProperty(b, TG_BOOKMARK, _Bookmark, count);
            count += serializeMessageProperty(b, TG_SEQUENCE, _Sequence, count);
            count += serializeMessageProperty(b, TG_TOPN, _TopN, count);
            count += serializeMessageProperty(b, TG_SENDEMPTIES, _SendEmpties, count);
            count += serializeMessageProperty(b, TG_MAXMESSAGES, _MaxMessages, count);
            count += serializeMessageProperty(b, TG_SOWKEYS, _SowKeys, count);
            b.put(CLOSE_BRACE);
            if(_Data.buffer != null)
            {
                b.put(_Data.buffer, _Data.position, _Data.length);
            }

            //dumpBuffer("SENDING> ",b.array(),4,b.position()-4);
        }
        catch (BufferOverflowException e)
        {
            return SerializationResult.BufferTooSmall;
        }
        return SerializationResult.OK;
    }
    public Message copy()
    {
        JSONMessage m = new JSONMessage(this.encoder, this.decoder);
        _copyTo(m);
        return m;
    }

    static private void dumpBuffer(String prefix,byte[] buffer,int start,int length)
    {
        System.err.print(prefix);
        for(int j = start; j < start+length; ++j)
        {
            try
            {
                System.err.print(new String(buffer,j,1,LATIN1));
            }
            catch(Exception e)
            {
                System.err.print("{error}");
            }
        }
        System.out.println();
    }
}
