////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////

package com.crankuptheamps.client.fields;

import java.io.UnsupportedEncodingException;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.Message.AckType;

public class AckTypeField extends Field
{
    protected static final String LATIN1       = "ISO-8859-1";
    protected static final byte   LATIN1_ZERO  = 48;

    private static byte[] AT_RECEIVED                                              = null;
    private static byte[] AT_PARSED                                                = null;
    private static byte[] AT_PERSISTED                                             = null;
    private static byte[] AT_PROCESSED                                             = null;
    private static byte[] AT_COMPLETED                                             = null;
    private static byte[] AT_STATS                                                 = null;
    private static byte[] AT_RECEIVED_PARSED                                       = null;
    private static byte[] AT_RECEIVED_PERSISTED                                    = null;
    private static byte[] AT_RECEIVED_PROCESSED                                    = null;
    private static byte[] AT_RECEIVED_COMPLETED                                    = null;
    private static byte[] AT_RECEIVED_STATS                                        = null;
    private static byte[] AT_PARSED_PERSISTED                                      = null;
    private static byte[] AT_PARSED_PROCESSED                                      = null;
    private static byte[] AT_PARSED_COMPLETED                                      = null;
    private static byte[] AT_PARSED_STATS                                          = null;
    private static byte[] AT_PERSISTED_PROCESSED                                   = null;
    private static byte[] AT_PERSISTED_COMPLETED                                   = null;
    private static byte[] AT_PERSISTED_STATS                                       = null;
    private static byte[] AT_PROCESSED_COMPLETED                                   = null;
    private static byte[] AT_PROCESSED_STATS                                       = null;
    private static byte[] AT_COMPLETED_STATS                                       = null;
    private static byte[] AT_RECEIVED_PARSED_PERSISTED                             = null;
    private static byte[] AT_RECEIVED_PARSED_PROCESSED                             = null;
    private static byte[] AT_RECEIVED_PARSED_COMPLETED                             = null;
    private static byte[] AT_RECEIVED_PARSED_STATS                                 = null;
    private static byte[] AT_RECEIVED_PERSISTED_PROCESSED                          = null;
    private static byte[] AT_RECEIVED_PERSISTED_COMPLETED                          = null;
    private static byte[] AT_RECEIVED_PERSISTED_STATS                              = null;
    private static byte[] AT_RECEIVED_PROCESSED_COMPLETED                          = null;
    private static byte[] AT_RECEIVED_PROCESSED_STATS                              = null;
    private static byte[] AT_RECEIVED_COMPLETED_STATS                              = null;
    private static byte[] AT_PARSED_PERSISTED_PROCESSED                            = null;
    private static byte[] AT_PARSED_PERSISTED_COMPLETED                            = null;
    private static byte[] AT_PARSED_PERSISTED_STATS                                = null;
    private static byte[] AT_PARSED_PROCESSED_COMPLETED                            = null;
    private static byte[] AT_PARSED_PROCESSED_STATS                                = null;
    private static byte[] AT_PARSED_COMPLETED_STATS                                = null;
    private static byte[] AT_PERSISTED_PROCESSED_COMPLETED                         = null;
    private static byte[] AT_PERSISTED_PROCESSED_STATS                             = null;
    private static byte[] AT_PERSISTED_COMPLETED_STATS                             = null;
    private static byte[] AT_PROCESSED_COMPLETED_STATS                             = null;
    private static byte[] AT_RECEIVED_PARSED_PERSISTED_PROCESSED                   = null;
    private static byte[] AT_RECEIVED_PARSED_PERSISTED_COMPLETED                   = null;
    private static byte[] AT_RECEIVED_PARSED_PERSISTED_STATS                       = null;
    private static byte[] AT_RECEIVED_PARSED_PROCESSED_COMPLETED                   = null;
    private static byte[] AT_RECEIVED_PARSED_PROCESSED_STATS                       = null;
    private static byte[] AT_RECEIVED_PARSED_COMPLETED_STATS                       = null;
    private static byte[] AT_RECEIVED_PERSISTED_PROCESSED_COMPLETED                = null;
    private static byte[] AT_RECEIVED_PERSISTED_PROCESSED_STATS                    = null;
    private static byte[] AT_RECEIVED_PERSISTED_COMPLETED_STATS                    = null;
    private static byte[] AT_RECEIVED_PROCESSED_COMPLETED_STATS                    = null;
    private static byte[] AT_PARSED_PERSISTED_PROCESSED_COMPLETED                  = null;
    private static byte[] AT_PARSED_PERSISTED_PROCESSED_STATS                      = null;
    private static byte[] AT_PARSED_PERSISTED_COMPLETED_STATS                      = null;
    private static byte[] AT_PARSED_PROCESSED_COMPLETED_STATS                      = null;
    private static byte[] AT_PERSISTED_PROCESSED_COMPLETED_STATS                   = null;
    private static byte[] AT_RECEIVED_PARSED_PERSISTED_PROCESSED_COMPLETED         = null;
    private static byte[] AT_RECEIVED_PARSED_PERSISTED_PROCESSED_STATS             = null;
    private static byte[] AT_RECEIVED_PARSED_PERSISTED_COMPLETED_STATS             = null;
    private static byte[] AT_RECEIVED_PARSED_PROCESSED_COMPLETED_STATS             = null;
    private static byte[] AT_RECEIVED_PERSISTED_PROCESSED_COMPLETED_STATS          = null;
    private static byte[] AT_PARSED_PERSISTED_PROCESSED_COMPLETED_STATS            = null;
    private static byte[] AT_RECEIVED_PARSED_PERSISTED_PROCESSED_COMPLETED_STATS   = null;

    static
    {
        try
        {
            AT_RECEIVED                                              = "received".getBytes(LATIN1);
            AT_PARSED                                                = "parsed".getBytes(LATIN1);
            AT_PERSISTED                                             = "persisted".getBytes(LATIN1);
            AT_PROCESSED                                             = "processed".getBytes(LATIN1);
            AT_COMPLETED                                             = "completed".getBytes(LATIN1);
            AT_STATS                                                 = "stats".getBytes(LATIN1);
            AT_RECEIVED_PARSED                                       = "received,parsed".getBytes(LATIN1);
            AT_RECEIVED_PERSISTED                                    = "received,persisted".getBytes(LATIN1);
            AT_RECEIVED_PROCESSED                                    = "received,processed".getBytes(LATIN1);
            AT_RECEIVED_COMPLETED                                    = "received,completed".getBytes(LATIN1);
            AT_RECEIVED_STATS                                        = "received,stats".getBytes(LATIN1);
            AT_PARSED_PERSISTED                                      = "parsed,persisted".getBytes(LATIN1);
            AT_PARSED_PROCESSED                                      = "parsed,processed".getBytes(LATIN1);
            AT_PARSED_COMPLETED                                      = "parsed,completed".getBytes(LATIN1);
            AT_PARSED_STATS                                          = "parsed,stats".getBytes(LATIN1);
            AT_PERSISTED_PROCESSED                                   = "persisted,processed".getBytes(LATIN1);
            AT_PERSISTED_COMPLETED                                   = "persisted,completed".getBytes(LATIN1);
            AT_PERSISTED_STATS                                       = "persisted,stats".getBytes(LATIN1);
            AT_PROCESSED_COMPLETED                                   = "processed,completed".getBytes(LATIN1);
            AT_PROCESSED_STATS                                       = "processed,stats".getBytes(LATIN1);
            AT_COMPLETED_STATS                                       = "completed,stats".getBytes(LATIN1);
            AT_RECEIVED_PARSED_PERSISTED                             = "received,parsed,persisted".getBytes(LATIN1);
            AT_RECEIVED_PARSED_PROCESSED                             = "received,parsed,processed".getBytes(LATIN1);
            AT_RECEIVED_PARSED_COMPLETED                             = "received,parsed,completed".getBytes(LATIN1);
            AT_RECEIVED_PARSED_STATS                                 = "received,parsed,stats".getBytes(LATIN1);
            AT_RECEIVED_PERSISTED_PROCESSED                          = "received,persisted,processed".getBytes(LATIN1);
            AT_RECEIVED_PERSISTED_COMPLETED                          = "received,persisted,completed".getBytes(LATIN1);
            AT_RECEIVED_PERSISTED_STATS                              = "received,persisted,stats".getBytes(LATIN1);
            AT_RECEIVED_PROCESSED_COMPLETED                          = "received,processed,completed".getBytes(LATIN1);
            AT_RECEIVED_PROCESSED_STATS                              = "received,processed,stats".getBytes(LATIN1);
            AT_RECEIVED_COMPLETED_STATS                              = "received,completed,stats".getBytes(LATIN1);
            AT_PARSED_PERSISTED_PROCESSED                            = "parsed,persisted,processed".getBytes(LATIN1);
            AT_PARSED_PERSISTED_COMPLETED                            = "parsed,persisted,completed".getBytes(LATIN1);
            AT_PARSED_PERSISTED_STATS                                = "parsed,persisted,stats".getBytes(LATIN1);
            AT_PARSED_PROCESSED_COMPLETED                            = "parsed,processed,completed".getBytes(LATIN1);
            AT_PARSED_PROCESSED_STATS                                = "parsed,processed,stats".getBytes(LATIN1);
            AT_PARSED_COMPLETED_STATS                                = "parsed,completed,stats".getBytes(LATIN1);
            AT_PERSISTED_PROCESSED_COMPLETED                         = "persisted,processed,completed".getBytes(LATIN1);
            AT_PERSISTED_PROCESSED_STATS                             = "persisted,processed,stats".getBytes(LATIN1);
            AT_PERSISTED_COMPLETED_STATS                             = "persisted,completed,stats".getBytes(LATIN1);
            AT_PROCESSED_COMPLETED_STATS                             = "processed,completed,stats".getBytes(LATIN1);
            AT_RECEIVED_PARSED_PERSISTED_PROCESSED                   = "received,parsed,persisted,processed".getBytes(LATIN1);
            AT_RECEIVED_PARSED_PERSISTED_COMPLETED                   = "received,parsed,persisted,completed".getBytes(LATIN1);
            AT_RECEIVED_PARSED_PERSISTED_STATS                       = "received,parsed,persisted,stats".getBytes(LATIN1);
            AT_RECEIVED_PARSED_PROCESSED_COMPLETED                   = "received,parsed,processed,completed".getBytes(LATIN1);
            AT_RECEIVED_PARSED_PROCESSED_STATS                       = "received,parsed,processed,stats".getBytes(LATIN1);
            AT_RECEIVED_PARSED_COMPLETED_STATS                       = "received,parsed,completed,stats".getBytes(LATIN1);
            AT_RECEIVED_PERSISTED_PROCESSED_COMPLETED                = "received,persisted,processed,completed".getBytes(LATIN1);
            AT_RECEIVED_PERSISTED_PROCESSED_STATS                    = "received,persisted,processed,stats".getBytes(LATIN1);
            AT_RECEIVED_PERSISTED_COMPLETED_STATS                    = "received,persisted,completed,stats".getBytes(LATIN1);
            AT_RECEIVED_PROCESSED_COMPLETED_STATS                    = "received,processed,completed,stats".getBytes(LATIN1);
            AT_PARSED_PERSISTED_PROCESSED_COMPLETED                  = "parsed,persisted,processed,completed".getBytes(LATIN1);
            AT_PARSED_PERSISTED_PROCESSED_STATS                      = "parsed,persisted,processed,stats".getBytes(LATIN1);
            AT_PARSED_PERSISTED_COMPLETED_STATS                      = "parsed,persisted,completed,stats".getBytes(LATIN1);
            AT_PARSED_PROCESSED_COMPLETED_STATS                      = "parsed,processed,completed,stats".getBytes(LATIN1);
            AT_PERSISTED_PROCESSED_COMPLETED_STATS                   = "persisted,processed,completed,stats".getBytes(LATIN1);
            AT_RECEIVED_PARSED_PERSISTED_PROCESSED_COMPLETED         = "received,parsed,persisted,processed,completed".getBytes(LATIN1);
            AT_RECEIVED_PARSED_PERSISTED_PROCESSED_STATS             = "received,parsed,persisted,processed,stats".getBytes(LATIN1);
            AT_RECEIVED_PARSED_PERSISTED_COMPLETED_STATS             = "received,parsed,persisted,completed,stats".getBytes(LATIN1);
            AT_RECEIVED_PARSED_PROCESSED_COMPLETED_STATS             = "received,parsed,processed,completed,stats".getBytes(LATIN1);
            AT_RECEIVED_PERSISTED_PROCESSED_COMPLETED_STATS          = "received,persisted,processed,completed,stats".getBytes(LATIN1);
            AT_PARSED_PERSISTED_PROCESSED_COMPLETED_STATS            = "parsed,persisted,processed,completed,stats".getBytes(LATIN1);
            AT_RECEIVED_PARSED_PERSISTED_PROCESSED_COMPLETED_STATS   = "received,parsed,persisted,processed,completed,stats".getBytes(LATIN1);
        }
        catch(UnsupportedEncodingException e)
        {
            //Absorb... these should never throw for ASCII
        }
    }


    public int getValue()
    {
        if(this.buffer != null)
        {
            return decodeAckType(this.buffer, this.position, this.length);
        }
        return AckType.None;
    }

    public void setValue(int v)
    {
        if(v == 0)
        {
            reset();
            return;
        }
        switch (v)
        {
        case AckType.Received:
            set(AT_RECEIVED);
            break;
        case AckType.Parsed:
            set(AT_PARSED);
            break;
        case AckType.Persisted:
            set(AT_PERSISTED);
            break;
        case AckType.Processed:
            set(AT_PROCESSED);
            break;
        case AckType.Completed:
            set(AT_COMPLETED);
            break;
        case AckType.Stats:
            set(AT_STATS);
            break;
        case AckType.Received | AckType.Parsed:
            set(AT_RECEIVED_PARSED);
            break;
        case AckType.Received | AckType.Persisted:
            set(AT_RECEIVED_PERSISTED);
            break;
        case AckType.Received | AckType.Processed:
            set(AT_RECEIVED_PROCESSED);
            break;
        case AckType.Received | AckType.Completed:
            set(AT_RECEIVED_COMPLETED);
            break;
        case AckType.Received | AckType.Stats:
            set(AT_RECEIVED_STATS);
            break;
        case AckType.Parsed | AckType.Persisted:
            set(AT_PARSED_PERSISTED);
            break;
        case AckType.Parsed | AckType.Processed:
            set(AT_PARSED_PROCESSED);
            break;
        case AckType.Parsed | AckType.Completed:
            set(AT_PARSED_COMPLETED);
            break;
        case AckType.Parsed | AckType.Stats:
            set(AT_PARSED_STATS);
            break;
        case AckType.Persisted | AckType.Processed:
            set(AT_PERSISTED_PROCESSED);
            break;
        case AckType.Persisted | AckType.Completed:
            set(AT_PERSISTED_COMPLETED);
            break;
        case AckType.Persisted | AckType.Stats:
            set(AT_PERSISTED_STATS);
            break;
        case AckType.Processed | AckType.Completed:
            set(AT_PROCESSED_COMPLETED);
            break;
        case AckType.Processed | AckType.Stats:
            set(AT_PROCESSED_STATS);
            break;
        case AckType.Completed | AckType.Stats:
            set(AT_COMPLETED_STATS);
            break;
        case AckType.Received | AckType.Parsed | AckType.Persisted:
            set(AT_RECEIVED_PARSED_PERSISTED);
            break;
        case AckType.Received | AckType.Parsed | AckType.Processed:
            set(AT_RECEIVED_PARSED_PROCESSED);
            break;
        case AckType.Received | AckType.Parsed | AckType.Completed:
            set(AT_RECEIVED_PARSED_COMPLETED);
            break;
        case AckType.Received | AckType.Parsed | AckType.Stats:
            set(AT_RECEIVED_PARSED_STATS);
            break;
        case AckType.Received | AckType.Persisted | AckType.Processed:
            set(AT_RECEIVED_PERSISTED_PROCESSED);
            break;
        case AckType.Received | AckType.Persisted | AckType.Completed:
            set(AT_RECEIVED_PERSISTED_COMPLETED);
            break;
        case AckType.Received | AckType.Persisted | AckType.Stats:
            set(AT_RECEIVED_PERSISTED_STATS);
            break;
        case AckType.Received | AckType.Processed | AckType.Completed:
            set(AT_RECEIVED_PROCESSED_COMPLETED);
            break;
        case AckType.Received | AckType.Processed | AckType.Stats:
            set(AT_RECEIVED_PROCESSED_STATS);
            break;
        case AckType.Received | AckType.Completed | AckType.Stats:
            set(AT_RECEIVED_COMPLETED_STATS);
            break;
        case AckType.Parsed | AckType.Persisted | AckType.Processed:
            set(AT_PARSED_PERSISTED_PROCESSED);
            break;
        case AckType.Parsed | AckType.Persisted | AckType.Completed:
            set(AT_PARSED_PERSISTED_COMPLETED);
            break;
        case AckType.Parsed | AckType.Persisted | AckType.Stats:
            set(AT_PARSED_PERSISTED_STATS);
            break;
        case AckType.Parsed | AckType.Processed | AckType.Completed:
            set(AT_PARSED_PROCESSED_COMPLETED);
            break;
        case AckType.Parsed | AckType.Processed | AckType.Stats:
            set(AT_PARSED_PROCESSED_STATS);
            break;
        case AckType.Parsed | AckType.Completed | AckType.Stats:
            set(AT_PARSED_COMPLETED_STATS);
            break;
        case AckType.Persisted | AckType.Processed | AckType.Completed:
            set(AT_PERSISTED_PROCESSED_COMPLETED);
            break;
        case AckType.Persisted | AckType.Processed | AckType.Stats:
            set(AT_PERSISTED_PROCESSED_STATS);
            break;
        case AckType.Persisted | AckType.Completed | AckType.Stats:
            set(AT_PERSISTED_COMPLETED_STATS);
            break;
        case AckType.Processed | AckType.Completed | AckType.Stats:
            set(AT_PROCESSED_COMPLETED_STATS);
            break;
        case AckType.Received | AckType.Parsed | AckType.Persisted | AckType.Processed:
            set(AT_RECEIVED_PARSED_PERSISTED_PROCESSED);
            break;
        case AckType.Received | AckType.Parsed | AckType.Persisted | AckType.Completed:
            set(AT_RECEIVED_PARSED_PERSISTED_COMPLETED);
            break;
        case AckType.Received | AckType.Parsed | AckType.Persisted | AckType.Stats:
            set(AT_RECEIVED_PARSED_PERSISTED_STATS);
            break;
        case AckType.Received | AckType.Parsed | AckType.Processed | AckType.Completed:
            set(AT_RECEIVED_PARSED_PROCESSED_COMPLETED);
            break;
        case AckType.Received | AckType.Parsed | AckType.Processed | AckType.Stats:
            set(AT_RECEIVED_PARSED_PROCESSED_STATS);
            break;
        case AckType.Received | AckType.Parsed | AckType.Completed | AckType.Stats:
            set(AT_RECEIVED_PARSED_COMPLETED_STATS);
            break;
        case AckType.Received | AckType.Persisted | AckType.Processed | AckType.Completed:
            set(AT_RECEIVED_PERSISTED_PROCESSED_COMPLETED);
            break;
        case AckType.Received | AckType.Persisted | AckType.Processed | AckType.Stats:
            set(AT_RECEIVED_PERSISTED_PROCESSED_STATS);
            break;
        case AckType.Received | AckType.Persisted | AckType.Completed | AckType.Stats:
            set(AT_RECEIVED_PERSISTED_COMPLETED_STATS);
            break;
        case AckType.Received | AckType.Processed | AckType.Completed | AckType.Stats:
            set(AT_RECEIVED_PROCESSED_COMPLETED_STATS);
            break;
        case AckType.Parsed | AckType.Persisted | AckType.Processed | AckType.Completed:
            set(AT_PARSED_PERSISTED_PROCESSED_COMPLETED);
            break;
        case AckType.Parsed | AckType.Persisted | AckType.Processed | AckType.Stats:
            set(AT_PARSED_PERSISTED_PROCESSED_STATS);
            break;
        case AckType.Parsed | AckType.Persisted | AckType.Completed | AckType.Stats:
            set(AT_PARSED_PERSISTED_COMPLETED_STATS);
            break;
        case AckType.Parsed | AckType.Processed | AckType.Completed | AckType.Stats:
            set(AT_PARSED_PROCESSED_COMPLETED_STATS);
            break;
        case AckType.Persisted | AckType.Processed | AckType.Completed | AckType.Stats:
            set(AT_PERSISTED_PROCESSED_COMPLETED_STATS);
            break;
        case AckType.Received | AckType.Parsed | AckType.Persisted | AckType.Processed
                | AckType.Completed:
            set(AT_RECEIVED_PARSED_PERSISTED_PROCESSED_COMPLETED);
            break;
        case AckType.Received | AckType.Parsed | AckType.Persisted | AckType.Processed
                | AckType.Stats:
            set(AT_RECEIVED_PARSED_PERSISTED_PROCESSED_STATS);
            break;
        case AckType.Received | AckType.Parsed | AckType.Persisted | AckType.Completed
                | AckType.Stats:
            set(AT_RECEIVED_PARSED_PERSISTED_COMPLETED_STATS);
            break;
        case AckType.Received | AckType.Parsed | AckType.Processed | AckType.Completed
                | AckType.Stats:
            set(AT_RECEIVED_PARSED_PROCESSED_COMPLETED_STATS);
            break;
        case AckType.Received | AckType.Persisted | AckType.Processed | AckType.Completed
                | AckType.Stats:
            set(AT_RECEIVED_PERSISTED_PROCESSED_COMPLETED_STATS);
            break;
        case AckType.Parsed | AckType.Persisted | AckType.Processed | AckType.Completed
                | AckType.Stats:
            set(AT_PARSED_PERSISTED_PROCESSED_COMPLETED_STATS);
            break;
        case AckType.Received | AckType.Parsed | AckType.Persisted | AckType.Processed
                | AckType.Completed | AckType.Stats:
            set(AT_RECEIVED_PARSED_PERSISTED_PROCESSED_COMPLETED_STATS);
            break;
        case AckType.None:
        default:
            reset();
            break;
        }
    }

    static final int decodeAckType(byte[] buffer, int pos, int len)
    {
        switch (len)
        {
        case 4:
            return Message.AckType.None;
        case 5:
            return Message.AckType.Stats;
        case 6:
            return Message.AckType.Parsed;
        case 8:
            return Message.AckType.Received;
        case 9:
            switch(buffer[pos+1])
            {
            case 'e':
                return Message.AckType.Persisted;
            case 'r':
                return Message.AckType.Processed;
            case 'o':
                return Message.AckType.Completed;
            }
        }
        return Message.AckType.None;
    }

    static final public String encodeAckType(int ack)
    {
        switch(ack)
        {
        case Message.AckType.Received:
            return "received";
        case Message.AckType.Parsed:
            return "parsed";
        case Message.AckType.Persisted:
            return "persisted";
        case Message.AckType.Processed:
            return "processed";
        case Message.AckType.Completed:
            return "completed";
        case Message.AckType.Stats:
            return "stats";
        case Message.AckType.None:
            return "none";
        default:
            return "none";
        }
    }

}
