////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////

package com.crankuptheamps.client.fields;

import java.io.UnsupportedEncodingException;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.Message.Command;

public class CommandField extends Field
{
    protected static final String LATIN1       = "ISO-8859-1";
    protected static final byte   LATIN1_ZERO  = 48;

    private static byte[] CT_SUBSCRIBE                = null;
    private static byte[] CT_UNSUBSCRIBE              = null;
    private static byte[] CT_PUBLISH                  = null;
    private static byte[] CT_SOW                      = null;
    private static byte[] CT_LOGON                    = null;
    private static byte[] CT_START_TIMER              = null;
    private static byte[] CT_STOP_TIMER               = null;
    private static byte[] CT_SOW_AND_SUBSCRIBE        = null;
    private static byte[] CT_DELTA_PUBLISH            = null;
    private static byte[] CT_DELTA_SUBSCRIBE          = null;
    private static byte[] CT_SOW_AND_DELTA_SUBSCRIBE  = null;
    private static byte[] CT_SOW_DELETE               = null;
    private static byte[] CT_GROUP_BEGIN              = null;
    private static byte[] CT_GROUP_END                = null;
    private static byte[] CT_OOF                      = null;
    private static byte[] CT_ACK                      = null;
    private static byte[] CT_HEARTBEAT                = null;
    private static byte[] CT_FLUSH                    = null;
    private static byte[] CT_UNKNOWN                  = null;

    static
    {
        try
        {
            CT_SUBSCRIBE                = "subscribe".getBytes(LATIN1);
            CT_UNSUBSCRIBE              = "unsubscribe".getBytes(LATIN1);
            CT_PUBLISH                  = "publish".getBytes(LATIN1);
            CT_SOW                      = "sow".getBytes(LATIN1);
            CT_LOGON                    = "logon".getBytes(LATIN1);
            CT_START_TIMER              = "start_timer".getBytes(LATIN1);
            CT_STOP_TIMER               = "stop_timer".getBytes(LATIN1);
            CT_SOW_AND_SUBSCRIBE        = "sow_and_subscribe".getBytes(LATIN1);
            CT_DELTA_PUBLISH            = "delta_publish".getBytes(LATIN1);
            CT_DELTA_SUBSCRIBE          = "delta_subscribe".getBytes(LATIN1);
            CT_SOW_AND_DELTA_SUBSCRIBE  = "sow_and_delta_subscribe".getBytes(LATIN1);
            CT_SOW_DELETE               = "sow_delete".getBytes(LATIN1);
            CT_GROUP_BEGIN              = "group_begin".getBytes(LATIN1);
            CT_GROUP_END                = "group_end".getBytes(LATIN1);
            CT_OOF                      = "oof".getBytes(LATIN1);
            CT_ACK                      = "ack".getBytes(LATIN1);
            CT_HEARTBEAT                = "heartbeat".getBytes(LATIN1);
            CT_FLUSH                    = "flush".getBytes(LATIN1);
            CT_UNKNOWN                  = "unknown".getBytes(LATIN1);
        }
        catch(UnsupportedEncodingException e)
        {
            //Absorb... these should never throw for ASCII
        }
    }


    public int getValue()
    {
        if(this.buffer != null)
        {
            return decodeCommand(this.buffer, this.position, this.length);
        }
        return Command.Unknown;
    }

    public void setValue(int v)
    {
        if(v == 0)
        {
            reset();
            return;
        }
        switch (v)
        {
        case Command.Subscribe:
            set(CT_SUBSCRIBE);
            break;
        case Command.Unsubscribe:
            set(CT_UNSUBSCRIBE);
            break;
        case Command.Publish:
            set(CT_PUBLISH);
            break;
        case Command.SOW:
            set(CT_SOW);
            break;
        case Command.Logon:
            set(CT_LOGON);
            break;
        case Command.StartTimer:
            set(CT_START_TIMER);
            break;
        case Command.StopTimer:
            set(CT_STOP_TIMER);
            break;
        case Command.SOWAndSubscribe:
            set(CT_SOW_AND_SUBSCRIBE);
            break;
        case Command.DeltaPublish:
            set(CT_DELTA_PUBLISH);
            break;
        case Command.DeltaSubscribe:
            set(CT_DELTA_SUBSCRIBE);
            break;
        case Command.SOWAndDeltaSubscribe:
            set(CT_SOW_AND_DELTA_SUBSCRIBE);
            break;
        case Command.SOWDelete:
            set(CT_SOW_DELETE);
            break;
        case Command.GroupBegin:
            set(CT_GROUP_BEGIN);
            break;
        case Command.GroupEnd:
            set(CT_GROUP_END);
            break;
        case Command.OOF:
            set(CT_OOF);
            break;
        case Command.Ack:
            set(CT_ACK);
            break;
        case Command.Heartbeat:
            set(CT_HEARTBEAT);
            break;
        case Command.Flush:
            set(CT_FLUSH);
            break;
        case Command.Unknown:
        default:
            set(CT_UNKNOWN);
            break;
        }
    }

    static final int decodeCommand(byte[] buffer, int pos, int len)
    {
        switch (len)
        {
	case 1:
	    switch(buffer[pos])
	    {
	    case 'p':
		return Message.Command.Publish;
	    }
	    break;
        case 3:
            // sow oof ack
            switch(buffer[pos])
            {
            case 's':
                return Message.Command.SOW;
            case 'o':
                return Message.Command.OOF;
            case 'a':
                return Message.Command.Ack;
            }
            break;
        case 5:
            // logon flush
            switch(buffer[pos])
            {
            case 'l':
                return Message.Command.Logon;
            case 'f':
                return Message.Command.Flush;
            }
            break;
        case 7:
            return Message.Command.Publish;
        case 9:
            // subscribe heartbeat group_end
            switch(buffer[pos])
            {
            case 's':
                return Message.Command.Subscribe;
            case 'h':
                return Message.Command.Heartbeat;
            case 'g':
                return Message.Command.GroupEnd;
            }
            break;
        case 10:
            // sow_delete stop_timer
            switch(buffer[pos+1])
            {
            case 'o':
                return Message.Command.SOWDelete;
            case 't':
                return Message.Command.StopTimer;
            }
            break;
        case 11:
            // unsubscribe start_timer group_begin
            switch(buffer[pos])
            {
            case 'u':
                return Message.Command.Unsubscribe;
            case 's':
                return Message.Command.StartTimer;
            case 'g':
                return Message.Command.GroupBegin;
            }
            break;
        case 13:
            return Message.Command.DeltaPublish;
        case 15:
            return Message.Command.DeltaSubscribe;
        case 17:
            // batch_publish_end sow_and_subscribe
            switch(buffer[pos])
            {
            case 's':
                return Message.Command.SOWAndSubscribe;
            }
            break;
        case 23:
            return Message.Command.SOWAndDeltaSubscribe;
        }
        return Message.Command.Unknown;
    }

    static final public String encodeCommand(int command)
    {
        switch(command)
        {
        case Message.Command.Publish:
            return "publish";
        case Message.Command.Subscribe:
            return "subscribe";
        case Message.Command.Unsubscribe:
            return "unsubscribe";
        case Message.Command.SOW:
            return "sow";
        case Message.Command.Heartbeat:
            return "heartbeat";
        case Message.Command.Logon:
            return "logon";
        case Message.Command.StartTimer:
            return "start_timer";
        case Message.Command.StopTimer:
            return "stop_timer";
        case Message.Command.SOWAndSubscribe:
            return "sow_and_subscribe";
        case Message.Command.DeltaPublish:
            return "delta_publish";
        case Message.Command.DeltaSubscribe:
            return "delta_subscribe";
        case Message.Command.SOWAndDeltaSubscribe:
            return "sow_and_delta_subscribe";
        case Message.Command.SOWDelete:
            return "sow_delete";
        case Message.Command.GroupBegin:
            return "group_begin";
        case Message.Command.GroupEnd:
            return "group_end";
        case Message.Command.OOF:
            return "oof";
        case Message.Command.Ack:
            return "ack";
        case Message.Command.Flush:
            return "flush";
        case Message.Command.Unknown:
            return "unknown";
        default:
            return "unknown";
        }
    }

}

