////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////

package com.crankuptheamps.client.fields;

import java.io.UnsupportedEncodingException;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.Message.Reason;

public class ReasonField extends Field
{
    protected static final String LATIN1       = "ISO-8859-1";
    
    /// NOTE THESE MUST MATCH the order in the Message.Reasons enum.
    private static String[] reasonStrings = {
         "",
         "duplicate",
         "bad filter",
         "bad regex topic",
         "subscription already exists",
         "deleted",
         "expired",
         "match",
         "invalid topic",
         "name in use",
         "auth failure",
         "not entitled",
         "authentication disabled",
         "invalid bookmark",
         "invalid orderby",
         "subid in use"
    };

    
    public int getValue()
    {
        if(this.buffer != null)
        {
            return decodeReason(this.buffer, this.position, this.length);
        }
        return Reason.None;
    }
    
    public String getText()
    {
        if(this.buffer != null)
        {
            return new String(this.buffer, this.position, this.length);
        }
        return "";
    }
    private void set(String value)
    {
        try
        {
            set(value.getBytes(LATIN1));
        } catch (UnsupportedEncodingException uex)
        {
            // this doesn't happen.
        }
    }
    
    public void setValue(int v)
    {
        if(v == 0 || v> reasonStrings.length-1)
        {
            reset();
            return;
        }
        set(reasonStrings[v]);
    }

    static final int decodeReason(byte[] buffer, int pos, int len)
    {
        String reasonBytes = new String(buffer, pos, len);
        for(int i = 0; i < reasonStrings.length; ++i)
        {
            if(reasonStrings[i].equals(reasonBytes)) return i;
        }
        
        return Message.Reason.Other;
        
    }

    static final public String encodeReason(int r)
    {
        if(r > reasonStrings.length-1) return "unknown";
        return reasonStrings[r];
    }

}

