////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////

package com.crankuptheamps.client.fields;

import java.io.UnsupportedEncodingException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

import com.crankuptheamps.client.CommandId;

public class StringField extends Field
{
    protected static final String LATIN1       = "ISO-8859-1";
    protected static final byte   LATIN1_ZERO  = 48;

    private ByteBuffer value = ByteBuffer.allocate(256);
    private byte[]     bytes = value.array();

    // These are used only for quick conversion without collecting garbage
    private CharBuffer charValue  = CharBuffer.allocate(256);
    private char[]     charBytes  = charValue.array();


    protected StringField(byte[] buffer, int position, int length)
    {
        super(buffer, position, length);
    }

    public StringField()
    {
    }


    public String getValue(CharsetDecoder decoder)
    {
        if(this.buffer != null)
        {
            return new String(this.buffer,this.position,this.length,decoder.charset());
        }
        return null;
    }
    public boolean getValue(ByteBuffer v)
    {
        if(this.buffer != null)
        {
            v.put(this.buffer,this.position,this.length);
            return true;
        }
        return false;
    }
    public boolean getValue(CommandId v)
    {
        if(this.buffer != null)
        {
            v.set(this.buffer,this.position,this.length);
            return true;
        }
        return false;
    }
    public void setValue(byte[] v,int offset,int length)
    {
        this.buffer   = v;
        this.position = offset;
        this.length   = length;
    }
    public void setValue(CommandId v)
    {
        this.buffer   = v.id;
        this.position = 0;
        if(v.id == null)
        {
            this.length   = 0;
        } else {
            this.length = v.id.length;
        }

    }
    public void setValue(String v, CharsetEncoder encoder)
    {
        if(v == null)
        {
            reset();
            return;
        }
        // Check if charbuffer conversion space needs expansion
        if(v.length() > charValue.capacity())
        {
            // Must resize
            int newSize = charValue.capacity();
            while(v.length() > newSize) newSize *= 2;
            charValue = CharBuffer.allocate(newSize);
            charBytes = charValue.array();
        }
        // Check if buffer storage space needs expansion
        if(v.length()*encoder.maxBytesPerChar() > value.capacity())
        {
            // Must resize
            int newSize = value.capacity();
            while(v.length()*encoder.maxBytesPerChar() > newSize) newSize *= 2;
            value = ByteBuffer.allocate(newSize);
            bytes = value.array();
        }
        // Copy to the charbuffer
        charValue.clear();
        v.getChars(0,v.length(),charBytes,0); // Turns out this method is faster than doing a put
        charValue.limit(v.length());

        // Encode to the byte buffer
        value.clear();
        encoder.reset();
        try
        {
            CoderResult result = encoder.encode(charValue,value,true);
            if(result.isError()) result.throwException();
        }
        catch(Exception ex)
        {
            throw new RuntimeException(ex);
        }
        set(bytes, 0, value.position());

        // getBytes is faster than using a CharBuffer, however, there's a bunch of garbage
        //    collected in using this method, so we avoid it. (about a 7% bump in performance, but
        //    under heavy load it creates some GC issues.)
        //try { this.buffer = v.getBytes(LATIN1); } catch(UnsupportedEncodingException e) {;}
    }
}

