////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////

package com.crankuptheamps.spark;

public class CommandOption
{
    private String  name        = null;
    private String  value       = null;
    private String  description = null;
    private boolean required    = false;
    private String  defaultValue= null;     

    public CommandOption(String name, String description, boolean required)
    {
        this.name = name;
        this.description = description;
        this.required = required;
    }
    public CommandOption(String name, String description, String defaultValue)
    {
        this.name = name;
        this.description = description;
        this.required = false;
        this.defaultValue = defaultValue;
    }

    public String getName()
    {
        return this.name;
    }

    public String getValue()
    {
        return this.value==null?this.defaultValue:this.value;
    }

    public void setValue(String value)
    {
        this.value = value;
    }

    public boolean hasValue()
    {
        return this.value != null || this.defaultValue != null;
    }

    public String getDescription()
    {
        return this.description;
    }

    public boolean isRequired()
    {
        return this.required;
    }
    
    public String getDefaultValue()
    {
        return this.defaultValue;
    }
}
