////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2025 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government’s use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////

package com.crankuptheamps.examples;

import com.crankuptheamps.client.Client;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.MessageHandler;
import com.crankuptheamps.client.fields.ReasonField;

import com.crankuptheamps.client.exception.AMPSException;

/**
 * Class to handle received messages. The class
 * implements an invoke(Message) method. That method
 * is called for each message received by the subscribe
 * command.
 *
 * @author 60East
 *
 */
public class BookmarkMessageHandler implements MessageHandler {

  private boolean sowfinished_ = false;
  private Client client_ = null; 


  /**
  * 
  * @param c The Client to use to discard processed messages.
  *
  */
  BookmarkMessageHandler(Client c) { 
     client_ = c;
  }

  /**
   * Method for handling AMPS messages. This implementation
   * prints the message data to stdout.
   *
   * @param m the message to handle.
   */
  public void invoke(Message m) {

    try {

    if (m.getCommand() == Message.Command.OOF)
    {
      System.out.println("Message no longer in focus because : "
                         + ReasonField.encodeReason(m.getReason()) +
                         " : " + m.getData() );
      client_.getBookmarkStore().discard(m);
      return;

    }
    if (m.getCommand() == Message.Command.GroupBegin)
    {
      System.out.println("Receiving messages from SOW (beginning of group).");
      sowfinished_ = false;
    }
    System.out.println(m.getData());
    if (m.getCommand() == Message.Command.GroupEnd)
    {
      System.out.println("Finished receiving messages from SOW (end of group).");
      sowfinished_ = true;
    }

    client_.getBookmarkStore().discard(m);

   }

   catch (AMPSException e)
   {
       System.err.println(e.getLocalizedMessage());
       e.printStackTrace(System.err);
   }

   
  }


  public boolean isSOWFinished() {
    return sowfinished_;
  }


}
