package com.crankuptheamps.examples;

import com.crankuptheamps.client.*;
import com.crankuptheamps.client.exception.*;

public class FIXBuilderPublisher {

  // The location of the AMPS server.
  private static final String uri_ = "tcp://127.0.0.1:9007/amps/fix";
  
  /**
   * main method.
   *
   * @param args -- No command line options read.
   */
  public static void main(String[] args) {

    System.out.println("Starting the console publisher");

    try (HAClient client = new HAClient("ConsolePublisher")) {
      // Build the message payload

      // Create a builder with 1024 bytes of initial capacity,
      // using the default 0x01 delimiter.
      FIXBuilder builder = new FIXBuilder(1024, (byte)1);

      // Add fields
      builder.append(0, "24");
      builder.append(1, "Here's another field");
      builder.append(2, "1234567890");

      // Create a string for the topic
      String topic = "messages";

      DefaultServerChooser sc = new DefaultServerChooser();
      sc.add(uri_);
      System.out.println("connecting...");
      client.setServerChooser(sc);
      client.connectAndLogon();
      System.out.println("connected..");

      // publish the message, using the overload that takes a byte array and
      // length for the topic and payload.
   
      client.publish(topic.getBytes(), 0, topic.length(), builder.getBytes(), 0, builder.getSize());
    }
    catch (AMPSException e)
    {
      System.err.println(e.getLocalizedMessage());
      e.printStackTrace(System.err);
    }
  }

}

