package com.crankuptheamps.examples;

import java.lang.Thread;

import com.crankuptheamps.client.*;
import com.crankuptheamps.client.exception.*;

/**
 * SubscribeForReplay
 *
 * This sample retrieves messages from a state-of-the-world database. The
 * program flow is simple:
 *
 * * Connect to AMPS
 * * Logon
 * * Request replay from "messages-history" topic from the last message
 * received.
 *
 * This sample doesn't include error handling or connection
 * retry logic.
 *
 * (c) 2013-2016 60East Technologies, Inc. All rights reserved.
 * This file is a part of the AMPS Evaluation Kit.
 */
public class SubscribeForReplay  {

  // The location of the AMPS server.
  private static final String uri_ = "tcp://127.0.0.1:9007/amps/json";

  /**
   * main method.
   *
   * @param args -- No command line options read.
   */

  public static void main(String[] args) {

    try (HAClient client = new HAClient("exampleSubscribeWithReplay");) {


      DefaultServerChooser sc = new DefaultServerChooser();
      sc.add(uri_);
      client.setServerChooser(sc);

      RingBookmarkStore bs = new RingBookmarkStore("bookmarks");
      client.setBookmarkStore(bs);

      client.connectAndLogon();

      // create the object to process the messages.
      BookmarkMessageHandler bmh = new BookmarkMessageHandler(client);

      System.out.println("... entering subscription ...");

      // Enter the subscription. This statement requests all
      // messages that have not been previously processed on the
      // "messages-history" topic.
   
      client.executeAsync( new Command(Message.Command.Subscribe)
                             .setTopic("messages-history")
                             .setSubId(new CommandId("sample-replay-id"))
                             .setBookmark(Client.Bookmarks.MOST_RECENT),
                          bmh);

      while (true)
      {
        Thread.sleep(100);
      }

    }
    catch (AMPSException e) {
      System.err.println(e.getLocalizedMessage());
      e.printStackTrace(System.err);
    }
    catch (InterruptedException e) {
      System.err.println(e.getLocalizedMessage());
      e.printStackTrace(System.err);
    }
  }

}
